/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.adapter.basic.EnumAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.cobblemon.mod.common.api.pokedex.FormDexRecord;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.cobblemon.mod.common.pokemon.Gender;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class FormDexRecordAdapter
implements IAdapter<FormDexRecord, class_2487, JsonObject, SpeciesDexRecord> {
    private static final EnumAdapter<Gender> GENDER_NAME = Adapters.ofEnum(Gender.class, EnumAdapter.Mode.NAME);
    private static final EnumAdapter<PokedexEntryProgress> KNOWLEDGE_ORDINAL = Adapters.ofEnum(PokedexEntryProgress.class, EnumAdapter.Mode.ORDINAL);
    private static final EnumAdapter<PokedexEntryProgress> KNOWLEDGE_NAME = Adapters.ofEnum(PokedexEntryProgress.class, EnumAdapter.Mode.NAME);

    @Override
    public void writeBits(FormDexRecord value, BitBuffer buffer, SpeciesDexRecord context) {
        Adapters.UTF_8.writeBits(value.getFormName(), buffer);
        Set genders = value.getGenders();
        Adapters.ofBoundedInt(8).writeBits((genders.contains(Gender.MALE) ? 1 : 0) | (genders.contains(Gender.FEMALE) ? 2 : 0) | (genders.contains(Gender.GENDERLESS) ? 4 : 0), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(value.getSeenShinyStates().size(), buffer);
        for (String state : value.getSeenShinyStates()) {
            Adapters.UTF_8.writeBits(state, buffer);
        }
        KNOWLEDGE_ORDINAL.writeBits(value.getKnowledge(), buffer);
    }

    @Override
    public Optional<FormDexRecord> readBits(BitBuffer buffer, SpeciesDexRecord context) {
        FormDexRecord record = new FormDexRecord();
        record.initialize(context, Adapters.UTF_8.readBits(buffer).orElseThrow());
        int packed = (Integer)Adapters.ofBoundedInt(8).readBits(buffer).orElseThrow();
        HashSet<Gender> genders = new HashSet<Gender>();
        if ((packed & 1) == 1) {
            genders.add(Gender.MALE);
        }
        if ((packed & 2) == 2) {
            genders.add(Gender.FEMALE);
        }
        if ((packed & 4) == 4) {
            genders.add(Gender.GENDERLESS);
        }
        record.getGenders().clear();
        record.getGenders().addAll(genders);
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        record.getSeenShinyStates().clear();
        for (int i = 0; i < size; ++i) {
            record.getSeenShinyStates().add(Adapters.UTF_8.readBits(buffer).orElseThrow());
        }
        record.setKnowledgeProgress(KNOWLEDGE_ORDINAL.readBits(buffer).orElseThrow());
        return Optional.of(record);
    }

    @Override
    public Optional<class_2487> writeNbt(FormDexRecord value, SpeciesDexRecord context) {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UTF_8.writeNbt(value.getFormName()).ifPresent(tag -> nbt.method_10566("name", tag));
            class_2499 genders = new class_2499();
            for (Gender gender : value.getGenders()) {
                GENDER_NAME.writeNbt(gender).ifPresent(arg_0 -> genders.add(arg_0));
            }
            nbt.method_10566("genders", (class_2520)genders);
            class_2499 seenShinyStates = new class_2499();
            for (String seenShinyState : value.getSeenShinyStates()) {
                Adapters.UTF_8.writeNbt(seenShinyState).ifPresent(arg_0 -> genders.add(arg_0));
            }
            nbt.method_10566("seenShinyStates", (class_2520)seenShinyStates);
            KNOWLEDGE_NAME.writeNbt(value.getKnowledge()).ifPresent(tag -> nbt.method_10566("knowledge", tag));
            return nbt;
        });
    }

    @Override
    public Optional<FormDexRecord> readNbt(class_2487 nbt, SpeciesDexRecord context) {
        if (nbt == null) {
            return Optional.empty();
        }
        FormDexRecord value = new FormDexRecord();
        value.initialize(context, Adapters.UTF_8.readNbt(nbt.method_10580("name")).orElseThrow());
        value.getGenders().clear();
        value.getSeenShinyStates().clear();
        Object object = nbt.method_10580("genders");
        if (object instanceof class_2499) {
            class_2499 genders = (class_2499)object;
            object = genders.iterator();
            while (object.hasNext()) {
                class_2520 gender = (class_2520)object.next();
                GENDER_NAME.readNbt(gender).ifPresent(value.getGenders()::add);
            }
        }
        if ((object = nbt.method_10580("seenShinyStates")) instanceof class_2499) {
            class_2499 seenShinyStates = (class_2499)object;
            for (class_2520 state : seenShinyStates) {
                Adapters.UTF_8.readNbt(state).ifPresent(value.getSeenShinyStates()::add);
            }
        }
        KNOWLEDGE_NAME.readNbt(nbt.method_10580("knowledge")).ifPresent(arg_0 -> ((FormDexRecord)value).setKnowledgeProgress(arg_0));
        return Optional.of(value);
    }
}

