/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.number;

import abeshutt.staracademy.data.adapter.number.IntAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SegmentedIntAdapter
extends IntAdapter {
    private final int bitSegment;
    private final int byteSegment;

    public SegmentedIntAdapter(int segment, boolean nullable) {
        super(nullable);
        this.bitSegment = segment;
        this.byteSegment = segment < 8 ? 1 : (segment < 16 ? 2 : (segment < 24 ? 3 : (segment < 32 ? 4 : 5)));
    }

    public int getBitSegment() {
        return this.bitSegment;
    }

    public int getByteSegment() {
        return this.byteSegment;
    }

    @Override
    public SegmentedIntAdapter asNullable() {
        return new SegmentedIntAdapter(this.bitSegment, true);
    }

    @Override
    protected void writeNumberBits(Integer value, BitBuffer buffer) {
        int segment = this.bitSegment;
        long mask = (1L << segment) - 1L;
        for (int shift = 0; shift < 32; shift += segment) {
            long bits = (long)value.intValue() & mask;
            value = value >>> segment;
            if (32 - shift <= segment) {
                buffer.writeLongBits(bits, 32 - shift);
                break;
            }
            if (value == 0) {
                buffer.writeLongBits(1L << segment | bits, segment + 1);
                break;
            }
            buffer.writeLongBits(bits, segment + 1);
        }
    }

    @Override
    protected Integer readNumberBits(BitBuffer buffer) {
        int segment = this.bitSegment;
        long mask = 1L << segment;
        int value = 0;
        for (int shift = 0; shift < 32; shift += segment) {
            if (32 - shift <= segment) {
                value = (int)((long)value | buffer.readLongBits(32 - shift) << shift);
                break;
            }
            long bits = buffer.readLongBits(segment + 1);
            if ((bits & mask) != 0L) {
                value = (int)((long)value | bits - mask << shift);
                break;
            }
            value = (int)((long)value | bits << shift);
        }
        return value;
    }

    @Override
    protected void writeNumberBytes(Integer value, ByteBuf buffer) {
        int segment = this.byteSegment * 8 - 1;
        long mask = (1L << segment) - 1L;
        for (int shift = 0; shift < 32; shift += segment) {
            int i;
            long bits = (long)value.intValue() & mask;
            value = value >>> segment;
            if (32 - shift <= segment) {
                for (i = 0; i < 32 - shift; i += 8) {
                    buffer.writeByte((int)((byte)(bits >>> i)));
                }
                break;
            }
            if (value == 0) {
                bits |= 1L << segment;
                for (i = 0; i <= segment; i += 8) {
                    buffer.writeByte((int)((byte)(bits >>> i)));
                }
                break;
            }
            for (i = 0; i <= segment; i += 8) {
                buffer.writeByte((int)((byte)(bits >>> i)));
            }
        }
    }

    @Override
    protected Integer readNumberBytes(ByteBuf buffer) {
        int segment = this.byteSegment * 8 - 1;
        long mask = 1L << segment;
        int value = 0;
        for (int shift = 0; shift < 32; shift += segment) {
            if (32 - shift <= segment) {
                int bits = 0;
                for (int i = 0; i < 32 - shift; i += 8) {
                    bits |= Byte.toUnsignedInt(buffer.readByte()) << i;
                }
                value |= bits << shift;
                break;
            }
            long bits = 0L;
            for (int i = 0; i <= segment; i += 8) {
                bits |= Byte.toUnsignedLong(buffer.readByte()) << i;
            }
            if ((bits & mask) != 0L) {
                value = (int)((long)value | bits - mask << shift);
                break;
            }
            value = (int)((long)value | bits << shift);
        }
        return value;
    }

    @Override
    protected void writeNumberData(Integer value, DataOutput data) throws IOException {
        int segment = this.byteSegment * 8 - 1;
        long mask = (1L << segment) - 1L;
        for (int shift = 0; shift < 32; shift += segment) {
            int i;
            long bits = (long)value.intValue() & mask;
            value = value >>> segment;
            if (32 - shift <= segment) {
                for (i = 0; i < 32 - shift; i += 8) {
                    data.writeByte((byte)(bits >>> i));
                }
                break;
            }
            if (value == 0) {
                bits |= 1L << segment;
                for (i = 0; i <= segment; i += 8) {
                    data.writeByte((byte)(bits >>> i));
                }
                break;
            }
            for (i = 0; i <= segment; i += 8) {
                data.writeByte((byte)(bits >>> i));
            }
        }
    }

    @Override
    protected Integer readNumberData(DataInput data) throws IOException {
        int segment = this.byteSegment * 8 - 1;
        long mask = 1L << segment;
        int value = 0;
        for (int shift = 0; shift < 32; shift += segment) {
            if (32 - shift <= segment) {
                int bits = 0;
                for (int i = 0; i < 32 - shift; i += 8) {
                    bits |= Byte.toUnsignedInt(data.readByte()) << i;
                }
                value |= bits << shift;
                break;
            }
            long bits = 0L;
            for (int i = 0; i <= segment; i += 8) {
                bits |= Byte.toUnsignedLong(data.readByte()) << i;
            }
            if ((bits & mask) != 0L) {
                value = (int)((long)value | bits - mask << shift);
                break;
            }
            value = (int)((long)value | bits << shift);
        }
        return value;
    }
}

