/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.nbt;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.nbt.GenericNbtAdapter;
import abeshutt.staracademy.data.adapter.nbt.NbtAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ListNbtAdapter
extends NbtAdapter<class_2499> {
    protected static final String[] ID_TO_KEY = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE_ARRAY", "STRING", "LIST", "COMPOUND", "INT_ARRAY", "LONG_ARRAY"};
    protected static final Object2IntMap<String> KEY_TO_ID = new Object2IntOpenHashMap();

    public ListNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public ListNbtAdapter asNullable() {
        return new ListNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(class_2499 value, BitBuffer buffer) {
        GenericNbtAdapter.NBT_ID.writeBits(value.method_10601(), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(value.size(), buffer);
        for (class_2520 element : value) {
            Adapters.NBT[value.method_10601()].writeBits(element, buffer);
        }
    }

    @Override
    protected class_2499 readTagBits(BitBuffer buffer) {
        class_2499 list = new class_2499();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((class_2520)Adapters.NBT[id].readBits(buffer).orElseThrow()));
        }
        return list;
    }

    @Override
    protected void writeTagBytes(class_2499 value, ByteBuf buffer) {
        GenericNbtAdapter.NBT_ID.writeBytes(value.method_10601(), buffer);
        Adapters.INT_SEGMENTED_3.writeBytes(value.size(), buffer);
        for (class_2520 element : value) {
            Adapters.NBT[value.method_10601()].writeBytes(element, buffer);
        }
    }

    @Override
    protected class_2499 readTagBytes(ByteBuf buffer) {
        class_2499 list = new class_2499();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readBytes(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((class_2520)Adapters.NBT[id].readBytes(buffer).orElseThrow()));
        }
        return list;
    }

    @Override
    protected void writeTagData(class_2499 value, DataOutput data) throws IOException {
        GenericNbtAdapter.NBT_ID.writeData(value.method_10601(), data);
        Adapters.INT_SEGMENTED_3.writeData(value.size(), data);
        for (class_2520 element : value) {
            Adapters.NBT[value.method_10601()].writeData(element, data);
        }
    }

    @Override
    protected class_2499 readTagData(DataInput data) throws IOException {
        class_2499 list = new class_2499();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readData(data).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((class_2520)Adapters.NBT[id].readData(data).orElseThrow()));
        }
        return list;
    }

    @Override
    protected class_2520 writeTagNbt(class_2499 value) {
        return value.method_10612();
    }

    @Override
    protected class_2499 readTagNbt(class_2520 nbt) {
        class_2499 class_24992;
        if (nbt instanceof class_2499) {
            class_2499 tag = (class_2499)nbt;
            class_24992 = tag.method_10612();
        } else {
            class_24992 = null;
        }
        return class_24992;
    }

    @Override
    protected JsonElement writeTagJson(class_2499 value) {
        JsonArray array = new JsonArray();
        if (!value.stream().allMatch(element -> element instanceof class_2487)) {
            array.add((Number)KEY_TO_ID.getInt((Object)value.method_10601()));
        }
        for (class_2520 tag : value) {
            Adapters.NBT[value.method_10601()].writeJson(tag).ifPresent(o -> array.add((JsonElement)o));
        }
        return array;
    }

    @Override
    protected class_2499 readTagJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && !(array = (JsonArray)json).isEmpty()) {
            int id;
            JsonPrimitive primitive;
            class_2499 list = new class_2499();
            JsonElement jsonElement = array.get(0);
            if (jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() && (id = KEY_TO_ID.getInt((Object)primitive.getAsString())) >= 0) {
                for (int i = 1; i < array.size(); ++i) {
                    Adapters.NBT[id].readJson(array.get(i)).ifPresent(tag -> list.add((Object)((class_2520)tag)));
                }
            } else {
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement element = array.get(i);
                    try {
                        Adapters.GENERIC_NBT.readJson(element).ifPresent(arg_0 -> list.add(arg_0));
                        continue;
                    }
                    catch (UnsupportedOperationException exception) {
                        return null;
                    }
                }
            }
            return list;
        }
        return null;
    }

    static {
        for (int i = 0; i < ID_TO_KEY.length; ++i) {
            KEY_TO_ID.put((Object)ID_TO_KEY[i], i);
        }
        KEY_TO_ID.defaultReturnValue(-1);
    }
}

