/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.nbt;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.nbt.NbtAdapter;
import abeshutt.staracademy.data.adapter.number.BoundedIntAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2483;
import net.minecraft.class_2520;

public class CollectionNbtAdapter
extends NbtAdapter<class_2483<?>> {
    private static NbtAdapter[] ADAPTERS = new NbtAdapter[]{Adapters.BYTE_ARRAY_NBT, Adapters.INT_ARRAY_NBT, Adapters.LONG_ARRAY_NBT, Adapters.LIST_NBT};
    private static final BoundedIntAdapter ID = new BoundedIntAdapter(0, ADAPTERS.length - 1, false);
    private static final Object2IntMap<Class<?>> TYPE_TO_ID = new Object2IntOpenHashMap();

    public CollectionNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public CollectionNbtAdapter asNullable() {
        return new CollectionNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(class_2483<?> value, BitBuffer buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBits(id, buffer);
        ADAPTERS[id].writeBits(value, buffer);
    }

    @Override
    protected class_2483<?> readTagBits(BitBuffer buffer) {
        int id = (Integer)ID.readBits(buffer).orElseThrow();
        return ADAPTERS[id].readBits(buffer).orElse(null);
    }

    @Override
    protected void writeTagBytes(class_2483<?> value, ByteBuf buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBytes(id, buffer);
        ADAPTERS[id].writeBytes(value, buffer);
    }

    @Override
    protected class_2483<?> readTagBytes(ByteBuf buffer) {
        int id = (Integer)ID.readBytes(buffer).orElseThrow();
        return ADAPTERS[id].readBytes(buffer).orElse(null);
    }

    @Override
    protected void writeTagData(class_2483<?> value, DataOutput data) throws IOException {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeData(id, data);
        ADAPTERS[id].writeData(value, data);
    }

    @Override
    protected class_2483<?> readTagData(DataInput data) throws IOException {
        int id = (Integer)ID.readData(data).orElseThrow();
        return ADAPTERS[id].readData(data).orElse(null);
    }

    @Override
    protected class_2520 writeTagNbt(class_2483<?> value) {
        return value;
    }

    @Override
    protected class_2483<?> readTagNbt(class_2520 nbt) {
        class_2483 tag;
        return nbt instanceof class_2483 ? (tag = (class_2483)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(class_2483<?> value) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        return ADAPTERS[id].writeJson(value).orElse(null);
    }

    @Override
    protected class_2483<?> readTagJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && !(array = (JsonArray)json).isEmpty()) {
            JsonPrimitive primitive;
            String key;
            JsonElement jsonElement = array.get(0);
            String string = key = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? primitive.getAsString() : null;
            if ("B".equals(key)) {
                return Adapters.BYTE_ARRAY_NBT.readJson(json).orElse(null);
            }
            if ("I".equals(key)) {
                return Adapters.INT_ARRAY_NBT.readJson(json).orElse(null);
            }
            if ("L".equals(key)) {
                return Adapters.LONG_ARRAY_NBT.readJson(json).orElse(null);
            }
        }
        return Adapters.LIST_NBT.readJson(json).orElse(null);
    }
}

