/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.basic;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2483;
import net.minecraft.class_2495;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class UuidAdapter
implements ISimpleAdapter<UUID, class_2520, JsonElement> {
    private final boolean nullable;

    public UuidAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public UuidAdapter asNullable() {
        return new UuidAdapter(true);
    }

    @Override
    public void writeBits(UUID value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(buffer.readLong(), buffer.readLong()));
    }

    @Override
    public void writeBytes(UUID value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(buffer.readLong(), buffer.readLong()));
    }

    @Override
    public void writeData(UUID value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeLong(value.getMostSignificantBits());
            data.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(data.readLong(), data.readLong()));
    }

    @Override
    public Optional<class_2520> writeNbt(UUID value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new class_2495(new int[]{(int)(value.getMostSignificantBits() >>> 32), (int)value.getMostSignificantBits(), (int)(value.getLeastSignificantBits() >>> 32), (int)value.getLeastSignificantBits()}));
    }

    @Override
    public Optional<UUID> readNbt(class_2520 nbt) {
        class_2483 array;
        class_2483 array2;
        if (nbt instanceof class_2483 && (array2 = (class_2483)nbt).size() == 4) {
            return Optional.of(new UUID((long)Adapters.INT.readNbt((class_2520)array2.get(0)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readNbt((class_2520)array2.get(1)).orElse(0)), (long)Adapters.INT.readNbt((class_2520)array2.get(2)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readNbt((class_2520)array2.get(3)).orElse(0))));
        }
        if (nbt instanceof class_2483 && (array = (class_2483)nbt).size() == 2) {
            return Optional.of(new UUID(Adapters.LONG.readNbt((class_2520)array.get(0)).orElse(0L), Adapters.LONG.readNbt((class_2520)array.get(1)).orElse(0L)));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            try {
                return Optional.of(UUID.fromString(string.method_10714()));
            }
            catch (IllegalStateException exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(UUID value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value.toString()));
    }

    @Override
    public Optional<UUID> readJson(JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        JsonArray array2;
        if (json instanceof JsonArray && (array2 = (JsonArray)json).size() == 4) {
            return Optional.of(new UUID((long)Adapters.INT.readJson(array2.get(0)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readJson(array2.get(1)).orElse(0)), (long)Adapters.INT.readJson(array2.get(2)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readJson(array2.get(3)).orElse(0))));
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 2) {
            return Optional.of(new UUID(Adapters.LONG.readJson(array.get(0)).orElse(0L), Adapters.LONG.readJson(array.get(1)).orElse(0L)));
        }
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            try {
                return Optional.of(UUID.fromString(primitive.getAsString()));
            }
            catch (IllegalStateException exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

