/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.array;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IBitAdapter;
import abeshutt.staracademy.data.adapter.IByteAdapter;
import abeshutt.staracademy.data.adapter.IDataAdapter;
import abeshutt.staracademy.data.adapter.IJsonAdapter;
import abeshutt.staracademy.data.adapter.INbtAdapter;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_2479;
import net.minecraft.class_2483;
import net.minecraft.class_2495;
import net.minecraft.class_2514;
import net.minecraft.class_2520;

public class IntArrayAdapter
implements ISimpleAdapter<int[], class_2520, JsonArray> {
    private final Object elementAdapter;
    private final boolean nullable;

    public IntArrayAdapter(Object elementAdapter, boolean nullable) {
        this.elementAdapter = elementAdapter;
        this.nullable = nullable;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public IntArrayAdapter asNullable() {
        return new IntArrayAdapter(this.elementAdapter, true);
    }

    @Override
    public final void writeBits(int[] value, BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBits(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBits((int)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<int[]> readBits(BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBits(buffer, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(int[] value, ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBytes(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBytes((int)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<int[]> readBytes(ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBytes(buffer, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(int[] value, DataOutput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeData(value.length, data);
            for (Object element : (Object)value) {
                adapter.writeData((int)element, data, null);
            }
        }
    }

    @Override
    public Optional<int[]> readData(DataInput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        int[] value = new int[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readData(data, null).orElse(0);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<class_2520> writeNbt(int[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        class_2514[] tags = new class_2514[value.length];
        for (int i = 0; i < value.length; ++i) {
            tags[i] = (class_2514)adapter.writeNbt(value[i], null).orElseThrow();
        }
        if (Arrays.stream(tags).allMatch(element -> element.method_10698() == element.method_10701())) {
            byte[] bytes = new byte[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                bytes[i] = tags[i].method_10698();
            }
            return Optional.of(new class_2479(bytes));
        }
        int[] ints = new int[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            ints[i] = tags[i].method_10701();
        }
        return Optional.of(new class_2495(ints));
    }

    @Override
    public final Optional<int[]> readNbt(class_2520 nbt) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return Optional.of(new int[]{numeric.method_10701()});
        }
        if (nbt instanceof class_2483) {
            class_2483 array = (class_2483)nbt;
            int[] value = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = adapter.readNbt((class_2520)array.get(i), null).orElse(0);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public final Optional<JsonArray> writeJson(int[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonPrimitive[] primitives = new JsonPrimitive[value.length];
        for (int i = 0; i < value.length; ++i) {
            primitives[i] = (JsonPrimitive)adapter.writeJson(value[i], null).orElseGet(() -> new JsonPrimitive((Number)0));
        }
        JsonArray ints = new JsonArray(primitives.length);
        for (JsonPrimitive primitive : primitives) {
            ints.add((Number)primitive.getAsInt());
        }
        return Optional.of(ints);
    }

    @Override
    public final Optional<int[]> readJson(JsonArray json) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        int[] value = new int[json.size()];
        for (int i = 0; i < json.size(); ++i) {
            value[i] = adapter.readJson(json.get(i), null).orElse(0);
        }
        return Optional.of(value);
    }
}

