/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter;

import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.bit.ArrayBitBuffer;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_8703;

public interface ISimpleAdapter<T, N extends class_2520, J extends JsonElement>
extends IAdapter<T, N, J, Object> {
    default public void writeBits(T value, BitBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    default public Optional<T> readBits(BitBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    default public void writeBytes(T value, ByteBuf buffer) {
        throw new UnsupportedOperationException();
    }

    default public Optional<T> readBytes(ByteBuf buffer) {
        throw new UnsupportedOperationException();
    }

    default public void writeData(T value, DataOutput data) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Optional<T> readData(DataInput data) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Optional<N> writeNbt(T value) {
        throw new UnsupportedOperationException();
    }

    default public Optional<T> readNbt(N nbt) {
        throw new UnsupportedOperationException();
    }

    default public Optional<J> writeJson(T value) {
        throw new UnsupportedOperationException();
    }

    default public Optional<T> readJson(J json) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void writeBits(T value, BitBuffer buffer, Object context) {
        this.writeBits(value, buffer);
    }

    @Override
    default public Optional<T> readBits(BitBuffer buffer, Object context) {
        return this.readBits(buffer);
    }

    @Override
    default public void writeBytes(T value, ByteBuf buffer, Object context) {
        this.writeBytes(value, buffer);
    }

    @Override
    default public Optional<T> readBytes(ByteBuf buffer, Object context) {
        return this.readBytes(buffer);
    }

    @Override
    default public void writeData(T value, DataOutput data, Object context) throws IOException {
        this.writeData(value, data);
    }

    @Override
    default public Optional<T> readData(DataInput data, Object context) throws IOException {
        return this.readData(data);
    }

    @Override
    default public Optional<N> writeNbt(T value, Object context) {
        return this.writeNbt(value);
    }

    @Override
    default public Optional<T> readNbt(N nbt, Object context) {
        return this.readNbt(nbt);
    }

    @Override
    default public Optional<J> writeJson(T value, Object context) {
        return this.writeJson(value);
    }

    @Override
    default public Optional<T> readJson(J json, Object context) {
        return this.readJson(json);
    }

    @Override
    default public JsonElement serialize(T value, Type source2, JsonSerializationContext context) {
        return this.writeJson(value, (Object)null).map(json -> json).orElse((JsonElement)JsonNull.INSTANCE);
    }

    @Override
    default public T deserialize(JsonElement json, Type source2, JsonDeserializationContext context) {
        return this.readJson((J)json, (Object)null).orElse(null);
    }

    @Override
    default public void encode(ByteBuf buf, T value) {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        this.writeBits(value, buffer);
        long[] serialized = buffer.toLongArray();
        class_8703.method_53017((ByteBuf)buf, (int)serialized.length);
        for (long l : serialized) {
            buf.writeLong(l);
        }
    }

    @Override
    default public T decode(ByteBuf buf) {
        int size = class_8703.method_53016((ByteBuf)buf);
        long[] serialized = new long[size];
        for (int i = 0; i < size; ++i) {
            serialized[i] = buf.readLong();
        }
        ArrayBitBuffer buffer = ArrayBitBuffer.backing(serialized, 0);
        return this.readBits(buffer).orElse(null);
    }

    default public Codec<T> codecNbt() {
        return new Codec<T>(){

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                try {
                    Object result = class_2509.field_11560.method_29146(ops, (class_2520)ISimpleAdapter.this.writeNbt(input).orElse(null));
                    return DataResult.success((Object)result);
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                class_2520 result = (class_2520)ops.convertTo((DynamicOps)class_2509.field_11560, input);
                try {
                    return DataResult.success((Object)new Pair(ISimpleAdapter.this.readNbt(result).orElse(null), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
    }

    default public Codec<T> codecJson() {
        return new Codec<T>(){

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                try {
                    Object result = JsonOps.INSTANCE.convertTo(ops, (JsonElement)ISimpleAdapter.this.writeJson(input).orElse(null));
                    return DataResult.success((Object)result);
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                JsonElement result = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
                try {
                    return DataResult.success((Object)new Pair(ISimpleAdapter.this.readJson(result).orElse(null), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
    }
}

