/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config.card;

import abeshutt.staracademy.attribute.AddAttribute;
import abeshutt.staracademy.attribute.AssignAttribute;
import abeshutt.staracademy.attribute.CardScalarAttribute;
import abeshutt.staracademy.attribute.NodeAttribute;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.path.AttributePath;
import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.config.FileConfig;
import abeshutt.staracademy.item.data.card.CardModifierEntry;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.WeightedList;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.roll.NumberRoll;
import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class CardModifiersConfig
extends FileConfig {
    @Expose
    private Map<String, CardModifierEntry> values;
    @Expose
    private Map<String, Map<String, Rational>> pools;

    @Override
    public String getPath() {
        return "card.modifiers";
    }

    public Optional<CardModifierEntry> get(String id) {
        return Optional.ofNullable(this.values.get(id));
    }

    public Option<String> flatten(String id, RandomSource random) {
        if (id.startsWith("@")) {
            Map<String, Rational> group = this.pools.get(id.substring(1));
            if (group == null) {
                return Option.absent();
            }
            WeightedList<String> weighted = WeightedList.of(group);
            return weighted.getRandom(random).mapFlat(s -> this.flatten((String)s, random));
        }
        return this.values.containsKey(id) ? Option.present(id) : Option.absent();
    }

    @Override
    protected void reset() {
        this.values = new LinkedHashMap<String, CardModifierEntry>();
        this.pools = new LinkedHashMap<String, Map<String, Rational>>();
        this.values.put("shiny_chance", new CardModifierEntry(AttributePath.absolute("shiny_chance", "increased"), 1, new AddAttribute<Rational>(AttributeTypes.number(), NodeAttribute.of(AttributeTypes.number()).add(null, 0, AssignAttribute.of(NumberRoll.uniformResolutionII(Rational.of(1, 100), Rational.of(5, 100), Rational.of(1, 100)))).add(null, 0, CardScalarAttribute.of("base")))));
        LinkedHashMap<String, Rational> all = new LinkedHashMap<String, Rational>();
        LinkedHashMap<String, Rational> special = new LinkedHashMap<String, Rational>();
        all.put("shiny_chance", Rational.ONE);
        special.put("shiny_chance", Rational.ONE);
        this.pools.put("all", all);
        this.pools.put("special", special);
    }
}

