/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config.card;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.config.FileConfig;
import abeshutt.staracademy.item.data.card.CardIconEntry;
import abeshutt.staracademy.item.data.card.CardRarity;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.WeightedList;
import abeshutt.staracademy.math.random.RandomSource;
import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class CardIconsConfig
extends FileConfig {
    @Expose
    private Map<String, CardIconEntry> values;
    @Expose
    private Map<String, Map<String, Rational>> pools;

    @Override
    public String getPath() {
        return "card.icons";
    }

    public Map<String, CardIconEntry> getValues() {
        return this.values;
    }

    public Optional<CardIconEntry> get(String id) {
        return Optional.ofNullable(this.values.get(id));
    }

    public Option<String> flatten(String id, RandomSource random) {
        if (id.startsWith("@")) {
            Map<String, Rational> group = this.pools.get(id.substring(1));
            if (group == null) {
                return Option.absent();
            }
            WeightedList<String> weighted = WeightedList.of(group);
            return weighted.getRandom(random).mapFlat(s -> this.flatten((String)s, random));
        }
        return this.values.containsKey(id) ? Option.present(id) : Option.absent();
    }

    @Override
    protected void reset() {
        this.values = new LinkedHashMap<String, CardIconEntry>();
        this.pools = new LinkedHashMap<String, Map<String, Rational>>();
        this.values.put("001bulbasaur", new CardIconEntry("cobblemon.species.bulbasaur.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/001bulbasaur"), 3856069, 2980968), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/001bulbasaurshiny"), 10875010, 3702354))));
        this.values.put("002ivysaur", new CardIconEntry("cobblemon.species.ivysaur.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/002ivysaur"), 3591871, 8550254), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/002ivysaurshiny"), 12382070, 4557142))));
        this.values.put("003venusaur", new CardIconEntry("cobblemon.species.venusaur.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/003venusaur"), 4901818, 9530209), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/003venusaurshiny"), 12185721, 7375708))));
        this.values.put("004charmander", new CardIconEntry("cobblemon.species.charmander.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/004charmander"), 16099937, 12473377), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/004charmandershiny"), 16506463, 15640388))));
        this.values.put("005charmeleon", new CardIconEntry("cobblemon.species.charmeleon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/005charmeleon"), 14043705, 14988180), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/005charmeleonshiny"), 15515216, 16378545))));
        this.values.put("006charizard", new CardIconEntry("cobblemon.species.charizard.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/006charizard"), 16160856, 9793351), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/006charizardshiny"), 6318709, 6109762))));
        this.values.put("007squirtle", new CardIconEntry("cobblemon.species.squirtle.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/007squirtle"), 8643034, 10970681), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/007squirtleshiny"), 10940131, 11635800))));
        this.values.put("008wartortle", new CardIconEntry("cobblemon.species.wartortle.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/008wartortle"), 15001842, 10387854), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/008wartortleshiny"), 12509399, 12026013))));
        this.values.put("009blastoise", new CardIconEntry("cobblemon.species.blastoise.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/009blastoise"), 12629932, 7166556), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/009blastoiseshiny"), 12890776, 8546151))));
        this.values.put("010caterpie", new CardIconEntry("cobblemon.species.caterpie.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/010caterpie"), 15261020, 7771194), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/010caterpieshiny"), 16769631, 14191431))));
        this.values.put("011metapod", new CardIconEntry("cobblemon.species.metapod.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/011metapod"), 6933574, 3122476), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/011metapodshiny"), 16741197, 13452835))));
        this.values.put("012butterfree", new CardIconEntry("cobblemon.species.butterfree.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/012butterfree"), 3875895, 13161440), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/012butterfreeshiny"), 3221567, 14667710))));
        this.values.put("013weedle", new CardIconEntry("cobblemon.species.weedle.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/013weedle"), 13462857, 15971222), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/013weedleshiny"), 15983527, 14392922))));
        this.values.put("014kakuna", new CardIconEntry("cobblemon.species.kakuna.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/014kakuna"), 16438359, 10711590), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/014kakunashiny"), 9170781, 4362015))));
        this.values.put("015beedrill", new CardIconEntry("cobblemon.species.beedrill.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/015beedrill"), 15323035, 5393497), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/015beedrillshiny"), 11330452, 5331310))));
        this.values.put("016pidgey", new CardIconEntry("cobblemon.species.pidgey.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/016pidgey"), 15386266, 9525044), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/016pidgeyshiny"), 15593343, 10264894))));
        this.values.put("017pidgeotto", new CardIconEntry("cobblemon.species.pidgeotto.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/017pidgeotto"), 15518865, 12477257), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/017pidgeottoshiny"), 16247195, 14006340))));
        this.values.put("018pidgeot", new CardIconEntry("cobblemon.species.pidgeot.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/018pidgeot"), 12664868, 15183985), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/018pidgeotshiny"), 16568415, 13011249))));
        this.values.put("019rattata", new CardIconEntry("cobblemon.species.rattata.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/019rattata"), 7481955, 11237783), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/019rattatashiny"), 13757857, 13420438))));
        this.values.put("020ratticate", new CardIconEntry("cobblemon.species.ratticate.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/020ratticate"), 12225886, 15125406), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/020ratticateshiny"), 15455407, 12144687))));
        this.values.put("021spearow", new CardIconEntry("cobblemon.species.spearow.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/021spearow"), 15380624, 11948356), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/021spearowshiny"), 15129973, 11441736))));
        this.values.put("022fearow", new CardIconEntry("cobblemon.species.fearow.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/022fearow"), 11888193, 15055001), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/022fearowshiny"), 13816481, 11379027))));
        this.values.put("023ekans", new CardIconEntry("cobblemon.species.ekans.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/023ekans"), 14582672, 10829447), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/023ekansshiny"), 10598505, 6979134))));
        this.values.put("024arbok", new CardIconEntry("cobblemon.species.arbok.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/024arbok"), 13262507, 7811683), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/024arbokshiny"), 16767863, 10317880))));
        this.values.put("025pikachu", new CardIconEntry("cobblemon.species.pikachu.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/025pikachu"), 16766794, 8407332), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/025pikachushiny"), 16754759, 0x884334))));
        this.values.put("026raichu", new CardIconEntry("cobblemon.species.raichu.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/026raichu"), 16499793, 8541226), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/026raichushiny"), 15450284, 9589552))));
        this.values.put("027sandshrew", new CardIconEntry("cobblemon.species.sandshrew.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/027sandshrew"), 16638591, 13283422), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/027sandshrewshiny"), 5536825, 12376732))));
        this.values.put("028sandslash", new CardIconEntry("cobblemon.species.sandslash.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/028sandslash"), 4140314, 13678714), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/028sandslashshiny"), 9775660, 15844520))));
        this.values.put("029nidoranf", new CardIconEntry("cobblemon.species.nidoranf.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/029nidoranf"), 12440575, 5931941), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/029nidoranfshiny"), 15379955, 10375073))));
        this.values.put("030nidorina", new CardIconEntry("cobblemon.species.nidorina.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/030nidorina"), 12255225, 6268602), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/030nidorinashiny"), 15048657, 10707594))));
        this.values.put("031nidoqueen", new CardIconEntry("cobblemon.species.nidoqueen.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/031nidoqueen"), 4757953, 10866636), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/031nidoqueenshiny"), 9683086, 12548229))));
        this.values.put("032nidoranm", new CardIconEntry("cobblemon.species.nidoranm.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/032nidoranm"), 12744628, 7024997), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/032nidoranmshiny"), 11985379, 8819592))));
        this.values.put("033nidorino", new CardIconEntry("cobblemon.species.nidorino.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/033nidorino"), 10905498, 9453944), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/033nidorinoshiny"), 9617860, 7832955))));
        this.values.put("034nidoking", new CardIconEntry("cobblemon.species.nidoking.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/034nidoking"), 11769025, 8410768), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/034nidokingshiny"), 2707100, 5865162))));
        this.values.put("035clefairy", new CardIconEntry("cobblemon.species.clefairy.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/035clefairy"), 0xFFB4B4, 8802384), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/035clefairyshiny"), 15125436, 11694964))));
        this.values.put("036clefable", new CardIconEntry("cobblemon.species.clefable.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/036clefable"), 0xFFAEAE, 12412778), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/036clefableshiny"), 16177620, 13733520))));
        this.values.put("037vulpix", new CardIconEntry("cobblemon.species.vulpix.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/037vulpix"), 13652252, 15564369), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/037vulpixshiny"), 13009949, 15318345))));
        this.values.put("038ninetales", new CardIconEntry("cobblemon.species.ninetales.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/038ninetales"), 16770443, 14592844), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/038ninetalesshiny"), 0xCBCBCB, 9211287))));
        this.values.put("039jigglypuff", new CardIconEntry("cobblemon.species.jigglypuff.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/039jigglypuff"), 15447758, 7563133), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/039jigglypuffshiny"), 15448536, 8087914))));
        this.values.put("040wigglytuff", new CardIconEntry("cobblemon.species.wigglytuff.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/040wigglytuff"), 14912937, 15650267), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/040wigglytuffshiny"), 14389982, 15388655))));
        this.values.put("041zubat", new CardIconEntry("cobblemon.species.zubat.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/041zubat"), 5669853, 8141446), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/041zubatshiny"), 10478697, 10004054))));
        this.values.put("042golbat", new CardIconEntry("cobblemon.species.golbat.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/042golbat"), 6590436, 5386590), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/042golbatshiny"), 8447076, 9789786))));
        this.values.put("043oddish", new CardIconEntry("cobblemon.species.oddish.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/043oddish"), 2464814, 2966382), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/043oddishshiny"), 6595625, 4156199))));
        this.values.put("044gloom", new CardIconEntry("cobblemon.species.gloom.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/044gloom"), 5648440, 8148067), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/044gloomshiny"), 8887100, 5726493))));
        this.values.put("045vileplume", new CardIconEntry("cobblemon.species.vileplume.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/045vileplume"), 14775667, 2046305), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/045vileplumeshiny"), 9804891, 8809020))));
        this.values.put("046paras", new CardIconEntry("cobblemon.species.paras.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/046paras"), 16691310, 12084806), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/046parasshiny"), 15895417, 11223348))));
        this.values.put("047parasect", new CardIconEntry("cobblemon.species.parasect.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/047parasect"), 16168047, 13526371), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/047parasectshiny"), 16175770, 13994885))));
        this.values.put("048venonat", new CardIconEntry("cobblemon.species.venonat.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/048venonat"), 8073578, 12482975), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/048venonatshiny"), 3624058, 8556478))));
        this.values.put("049venomoth", new CardIconEntry("cobblemon.species.venomoth.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/049venomoth"), 15455204, 12691130), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/049venomothshiny"), 9287928, 6722510))));
        this.values.put("050diglet", new CardIconEntry("cobblemon.species.diglet.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/050diglet"), 11235151, 5521723), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/050digletshiny"), 9929862, 5655362))));
        this.values.put("051dugtrio", new CardIconEntry("cobblemon.species.dugtrio.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/051dugtrio"), 11628880, 5783092), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/051dugtrioshiny"), 10783369, 5654590))));
        this.values.put("052meowth", new CardIconEntry("cobblemon.species.meowth.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/052meowth"), 16379059, 11043413), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/052meowthshiny"), 15919809, 11435889))));
        this.values.put("053persian", new CardIconEntry("cobblemon.species.persian.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/053persian"), 16313267, 11705446), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/053persianshiny"), 15854286, 11311230))));
        this.values.put("054psyduck", new CardIconEntry("cobblemon.species.psyduck.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/054psyduck"), 16705440, 13280865), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/054psyduckshiny"), 10150119, 6861761))));
        this.values.put("055golduck", new CardIconEntry("cobblemon.species.golduck.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/055golduck"), 3635368, 6798820), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/055golduckshiny"), 3583980, 7891605))));
        this.values.put("056mankey", new CardIconEntry("cobblemon.species.mankey.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/056mankey"), 15851444, 12683877), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/056mankeyshiny"), 13822355, 11577430))));
        this.values.put("057primeape", new CardIconEntry("cobblemon.species.primeape.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/057primeape"), 15124640, 9265993), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/057primeapeshiny"), 14729372, 8680525))));
        this.values.put("058growlithe", new CardIconEntry("cobblemon.species.growlithe.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/058growlithe"), 15585941, 12218429), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/058growlitheshiny"), 15528373, 12429651))));
        this.values.put("059arcanine", new CardIconEntry("cobblemon.species.arcanine.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/059arcanine"), 15782802, 12024140), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/059arcanineshiny"), 16054182, 12428887))));
        this.values.put("060poliwag", new CardIconEntry("cobblemon.species.poliwag.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/060poliwag"), 3690370, 13425399), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/060poliwagshiny"), 13430775, 0x387383))));
        this.values.put("061poliwhirl", new CardIconEntry("cobblemon.species.poliwhirl.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/061poliwhirl"), 2243160, 11847143), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/061poliwhirlshiny"), 11852263, 2247764))));
        this.values.put("062poliwrath", new CardIconEntry("cobblemon.species.poliwrath.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/062poliwrath"), 10072545, 2441320), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/062poliwrathshiny"), 12115102, 4547370))));
        this.values.put("063abra", new CardIconEntry("cobblemon.species.abra.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/063abra"), 16763249, 11897933), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/063abrashiny"), 16049314, 11707498))));
        this.values.put("064kadabra", new CardIconEntry("cobblemon.species.kadabra.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/064kadabra"), 16698752, 10583897), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/064kadabrashiny"), 16444592, 11115122))));
        this.values.put("065alakazam", new CardIconEntry("cobblemon.species.alakazam.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/065alakazam"), 16769923, 9464149), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/065alakazamshiny"), 16381872, 11237246))));
        this.values.put("066machop", new CardIconEntry("cobblemon.species.machop.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/066machop"), 13828078, 10988704), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/066machopshiny"), 16180405, 11768968))));
        this.values.put("067machoke", new CardIconEntry("cobblemon.species.machoke.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/067machoke"), 12895728, 9141419), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/067machokeshiny"), 10808994, 0x88AB8B))));
        this.values.put("068machamp", new CardIconEntry("cobblemon.species.machamp.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/068machamp"), 14213115, 11840445), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/068machampshiny"), 11009951, 11059852))));
        this.values.put("069bellsprout", new CardIconEntry("cobblemon.species.bellsprout.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/069bellsprout"), 13557109, 7893324), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/069bellsproutshiny"), 15916413, 9075020))));
        this.values.put("070weepinbell", new CardIconEntry("cobblemon.species.weepinbell.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/070weepinbell"), 14409872, 7433550), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/070weepinbellshiny"), 12972695, 6978131))));
        this.values.put("071victreebel", new CardIconEntry("cobblemon.species.victreebel.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/071victreebel"), 12051841, 10061910), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/071victreebelshiny"), 14083729, 8881516))));
        this.values.put("072tentacool", new CardIconEntry("cobblemon.species.tentacool.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/072tentacool"), 9355995, 8736346), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/072tentacoolshiny"), 9879447, 8744356))));
        this.values.put("073tentacruel", new CardIconEntry("cobblemon.species.tentacruel.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/073tentacruel"), 8637682, 9061192), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/073tentacruelshiny"), 7716311, 5070975))));
        this.values.put("074geodude", new CardIconEntry("cobblemon.species.geodude.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/074geodude"), 13353141, 10392194), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/074geodudeshiny"), 16113251, 12815143))));
        this.values.put("075graveller", new CardIconEntry("cobblemon.species.graveller.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/075graveller"), 13747638, 11176320), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/075gravellershiny"), 13802331, 10644547))));
        this.values.put("076golem", new CardIconEntry("cobblemon.species.golem.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/076golem"), 6904398, 10194817), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/076golemshiny"), 8476201, 12362371))));
        this.values.put("077ponyta", new CardIconEntry("cobblemon.species.ponyta.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/077ponyta"), 16508307, 15103042), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/077ponytashiny"), 8763864, 12450530))));
        this.values.put("078rapidash", new CardIconEntry("cobblemon.species.rapidash.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/078rapidash"), 16771479, 14516047), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/078rapidashshiny"), 0x666788, 13486264))));
        this.values.put("079slowpoke", new CardIconEntry("cobblemon.species.slowpoke.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/079slowpoke"), 14913157, 16442581), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/079slowpokeshiny"), 14526370, 16313572))));
        this.values.put("080slowbro", new CardIconEntry("cobblemon.species.slowbro.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/080slowbro"), 12357014, 0xEEDDCD), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/080slowbroshiny"), 11242920, 15195349))));
        this.values.put("081magnemite", new CardIconEntry("cobblemon.species.magnemite.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/081magnemite"), 14738167, 9013671), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/081magnemiteshiny"), 15659223, 8684940))));
        this.values.put("082magneton", new CardIconEntry("cobblemon.species.magneton.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/082magneton"), 13948655, 8355228), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/082magnetonshiny"), 14540750, 6908790))));
        this.values.put("083farfetchd", new CardIconEntry("cobblemon.species.farfetchd.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/083farfetchd"), 12232302, 7758148), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/083farfetchdshiny"), 13677727, 10641756))));
        this.values.put("084doduo", new CardIconEntry("cobblemon.species.doduo.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/084doduo"), 15976070, 11765063), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/084doduoshiny"), 14742458, 10335336))));
        this.values.put("085dodrio", new CardIconEntry("cobblemon.species.dodrio.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/085dodrio"), 15845267, 6175535), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/085dodrioshiny"), 15134903, 7230275))));
        this.values.put("086seel", new CardIconEntry("cobblemon.species.seel.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/086seel"), 15593210, 13220805), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/086seelshiny"), 16515052, 14731192))));
        this.values.put("087dewgong", new CardIconEntry("cobblemon.species.dewgong.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/087dewgong"), 15330559, 11975383), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/087dewgongshiny"), 16317662, 13423024))));
        this.values.put("088grimer", new CardIconEntry("cobblemon.species.grimer.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/088grimer"), 13537728, 8343154), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/088grimershiny"), 10210988, 5667940))));
        this.values.put("089muk", new CardIconEntry("cobblemon.species.muk.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/089muk"), 10453399, 6571356), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/089mukshiny"), 8429705, 0x44664E))));
        this.values.put("090shellder", new CardIconEntry("cobblemon.species.shellder.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/090shellder"), 10128329, 4013168), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/090shelldershiny"), 15249510, 6834985))));
        this.values.put("091cloyster", new CardIconEntry("cobblemon.species.cloyster.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/091cloyster"), 8619712, 4407409), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/091cloystershiny"), 8692930, 4281969))));
        this.values.put("092gastly", new CardIconEntry("cobblemon.species.gastly.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/092gastly"), 9989528, 0x242234), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/092gastlyshiny"), 7503260, 2831674))));
        this.values.put("093haunter", new CardIconEntry("cobblemon.species.haunter.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/093haunter"), 0x66336C, 9525635), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/093hauntershiny"), 3356012, 5595549))));
        this.values.put("094gengar", new CardIconEntry("cobblemon.species.gengar.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/094gengar"), 1181739, 5059418), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/094gengarshiny"), 1578294, 5852532))));
        this.values.put("095onix", new CardIconEntry("cobblemon.species.onix.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/095onix"), 12238535, 7238527), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/095onixshiny"), 12109708, 7634511))));
        this.values.put("096drowzee", new CardIconEntry("cobblemon.species.drowzee.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/096drowzee"), 16572032, 6838594), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/096drowzeeshiny"), 0xFCCEEF, 8866921))));
        this.values.put("097hypno", new CardIconEntry("cobblemon.species.hypno.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/097hypno"), 16574627, 13810293), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/097hypnoshiny"), 16168656, 14381980))));
        this.values.put("098krabby", new CardIconEntry("cobblemon.species.krabby.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/098krabby"), 14777919, 16500373), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/098krabbyshiny"), 16508309, 14790463))));
        this.values.put("099kingler", new CardIconEntry("cobblemon.species.kingler.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/099kingler"), 16498827, 13004857), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/099kinglershiny"), 13232299, 9153630))));
        this.values.put("100voltorb", new CardIconEntry("cobblemon.species.voltorb.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/100voltorb"), 13317182, 15965603), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/100voltorbshiny"), 3364299, 10334451))));
        this.values.put("101electrode", new CardIconEntry("cobblemon.species.electrode.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/101electrode"), 0xFAFAFA, 11944008), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/101electrodeshiny"), 0xFAFAFA, 4212918))));
        this.values.put("102exeggcute", new CardIconEntry("cobblemon.species.exeggcute.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/102exeggcute"), 12548468, 16762811), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/102exeggcuteshiny"), 16639415, 13082217))));
        this.values.put("103exeggutor", new CardIconEntry("cobblemon.species.exeggutor.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/103exeggutor"), 12050068, 9076059), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/103exeggutorshiny"), 14532754, 9398603))));
        this.values.put("104cubone", new CardIconEntry("cobblemon.species.cubone.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/104cubone"), 15921383, 13080928), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/104cuboneshiny"), 15330783, 7118949))));
        this.values.put("105marowak", new CardIconEntry("cobblemon.species.marowak.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/105marowak"), 16248285, 12226654), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/105marowakshiny"), 14871750, 0xA6AB6A))));
        this.values.put("106hitmonlee", new CardIconEntry("cobblemon.species.hitmonlee.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/106hitmonlee"), 15323554, 9924446), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/106hitmonleeshiny"), 9082727, 14084779))));
        this.values.put("107hitmonchan", new CardIconEntry("cobblemon.species.hitmonchan.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/107hitmonchan"), 11707047, 11615039), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/107hitmonchanshiny"), 10991539, 0x4141AA))));
        this.values.put("108lickitung", new CardIconEntry("cobblemon.species.lickitung.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/108lickitung"), 16762291, 14646911), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/108lickitungshiny"), 16705729, 14979968))));
        this.values.put("109koffing", new CardIconEntry("cobblemon.species.koffing.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/109koffing"), 10771360, 12489907), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/109koffingshiny"), 9290418, 8361633))));
        this.values.put("110weezing", new CardIconEntry("cobblemon.species.weezing.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/110weezing"), 12556720, 10705041), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/110weezingshiny"), 9616067, 9076643))));
        this.values.put("111rhyhorn", new CardIconEntry("cobblemon.species.rhyhorn.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/111rhyhorn"), 11055306, 7238544), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/111rhyhornshiny"), 14398359, 11040601))));
        this.values.put("112rhydon", new CardIconEntry("cobblemon.species.rhydon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/112rhydon"), 11646923, 9210519), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/112rhydonshiny"), 13554605, 10920316))));
        this.values.put("113chansey", new CardIconEntry("cobblemon.species.chansey.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/113chansey"), 16633802, 15111318), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/113chanseyshiny"), 15131595, 12952729))));
        this.values.put("114tangela", new CardIconEntry("cobblemon.species.tangela.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/114tangela"), 7897519, 3939354), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/114tangelashiny"), 6866270, 6894122))));
        this.values.put("115kangaskhan", new CardIconEntry("cobblemon.species.kangaskhan.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/115kangaskhan"), 15325108, 10058853), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/115kangaskhanshiny"), 15130578, 9801336))));
        this.values.put("116horsea", new CardIconEntry("cobblemon.species.horsea.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/116horsea"), 10742246, 6143185), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/116horseashiny"), 8120271, 0xBAAAA6))));
        this.values.put("117seadra", new CardIconEntry("cobblemon.species.seadra.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/117seadra"), 10415604, 5753823), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/117seadrashiny"), 11184620, 6584016))));
        this.values.put("118goldeen", new CardIconEntry("cobblemon.species.goldeen.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/118goldeen"), 0xF8F8F5, 14506305), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/118goldeenshiny"), 0xF8F8F5, 14583356))));
        this.values.put("119seaking", new CardIconEntry("cobblemon.species.seaking.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/119seaking"), 0xF6F6F4, 9322029), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/119seakingshiny"), 0xF6F6F4, 9332266))));
        this.values.put("120staryu", new CardIconEntry("cobblemon.species.staryu.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/120staryu"), 14658130, 10705468), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/120staryushiny"), 15917490, 10586005))));
        this.values.put("121starmie", new CardIconEntry("cobblemon.species.starmie.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/121starmie"), 12692371, 8601179), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/121starmieshiny"), 10458553, 8538509))));
        this.values.put("122mrmime", new CardIconEntry("cobblemon.species.mrmime.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/122mrmime"), 15844806, 5523047), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/122mrmimeshiny"), 13232823, 6973056))));
        this.values.put("123scyther", new CardIconEntry("cobblemon.species.scyther.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/123scyther"), 10669903, 14020264), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/123scythershiny"), 10731596, 13954728))));
        this.values.put("124jynx", new CardIconEntry("cobblemon.species.jynx.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/124jynx"), 16376708, 13387593), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/124jynxshiny"), 12998784, 15521469))));
        this.values.put("125electabuzz", new CardIconEntry("cobblemon.species.electabuzz.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/125electabuzz"), 16768095, 7820853), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/125electabuzzshiny"), 16222823, 7485756))));
        this.values.put("126magmar", new CardIconEntry("cobblemon.species.magmar.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/126magmar"), 16109157, 12598559), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/126magmarshiny"), 11289705, 15444928))));
        this.values.put("127pinsir", new CardIconEntry("cobblemon.species.pinsir.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/127pinsir"), 15722457, 10850158), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/127pinsirshiny"), 14276083, 7169453))));
        this.values.put("128tauros", new CardIconEntry("cobblemon.species.tauros.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/128tauros"), 0xBB9966, 4537661), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/128taurosshiny"), 12892251, 0x555055))));
        this.values.put("129magikarp", new CardIconEntry("cobblemon.species.magikarp.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/129magikarp"), 16092241, 16179347), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/129magikarpshiny"), 15451729, 0xFFEE99))));
        this.values.put("130gyarados", new CardIconEntry("cobblemon.species.gyarados.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/130gyarados"), 12968416, 7182761), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/130gyaradosshiny"), 15590860, 14370384))));
        this.values.put("131lapras", new CardIconEntry("cobblemon.species.lapras.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/131lapras"), 10738145, 6591416), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/131laprasshiny"), 8872896, 13813447))));
        this.values.put("132ditto", new CardIconEntry("cobblemon.species.ditto.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/132ditto"), 15901388, 13003151), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/132dittoshiny"), 10216697, 6269647))));
        this.values.put("133eevee", new CardIconEntry("cobblemon.species.eevee.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/133eevee"), 12557689, 9330753), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/133eeveeshiny"), 15131871, 12169900))));
        this.values.put("134vaporeon", new CardIconEntry("cobblemon.species.vaporeon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/134vaporeon"), 10023409, 6124445), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/134vaporeonshiny"), 13876449, 9982608))));
        this.values.put("135jolteon", new CardIconEntry("cobblemon.species.jolteon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/135jolteon"), 16376724, 12420151), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/135jolteonshiny"), 13432958, 9407101))));
        this.values.put("136flareon", new CardIconEntry("cobblemon.species.flareon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/136flareon"), 15716218, 12080148), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/136flareonshiny"), 14673282, 11306527))));
        this.values.put("137porygon", new CardIconEntry("cobblemon.species.porygon.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/137porygon"), 7466466, 11496565), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/137porygonshiny"), 14386394, 6705361))));
        this.values.put("138omanyte", new CardIconEntry("cobblemon.species.omanyte.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/138omanyte"), 12579567, 10861208), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/138omanyteshiny"), 14866861, 13726950))));
        this.values.put("139omastar", new CardIconEntry("cobblemon.species.omastar.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/139omastar"), 12119774, 9810321), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/139omastarshiny"), 12082894, 15189934))));
        this.values.put("140kabuto", new CardIconEntry("cobblemon.species.kabuto.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/140kabuto"), 13533759, 4004646), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/140kabutoshiny"), 10144065, 4596518))));
        this.values.put("141kabutops", new CardIconEntry("cobblemon.species.kabutops.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/141kabutops"), 9786151, 15521994), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/141kabutopsshiny"), 13623467, 6387765))));
        this.values.put("142aerodactyl", new CardIconEntry("cobblemon.species.aerodactyl.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/142aerodactyl"), 0xAAACCD, 8087968), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/142aerodactylshiny"), 12691405, 7370406))));
        this.values.put("143snorlax", new CardIconEntry("cobblemon.species.snorlax.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/143snorlax"), 16116929, 3045028), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/143snorlaxshiny"), 16116929, 2840998))));
        this.values.put("144articuno", new CardIconEntry("cobblemon.species.articuno.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/144articuno"), 10476280, 2856139), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/144articunoshiny"), 13034739, 5413311))));
        this.values.put("145zapdos", new CardIconEntry("cobblemon.species.zapdos.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/145zapdos"), 0xFFDD66, 11894308), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/145zapdosshiny"), 16569154, 11760655))));
        this.values.put("146moltres", new CardIconEntry("cobblemon.species.moltres.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/146moltres"), 16564287, 15893817), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/146moltresshiny"), 16556101, 14052729))));
        this.values.put("147dratini", new CardIconEntry("cobblemon.species.dratini.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/147dratini"), 0xF4F4F4, 8882149), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/147dratinishiny"), 0xF4F4F4, 14911460))));
        this.values.put("148dragonair", new CardIconEntry("cobblemon.species.dragonair.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/148dragonair"), 5812205, 14544631), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/148dragonairshiny"), 15499460, 16377844))));
        this.values.put("149dragonite", new CardIconEntry("cobblemon.species.dragonite.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/149dragonite"), 13736504, 15388543), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/149dragoniteshiny"), 8754286, 11590815))));
        this.values.put("150mewtwo", new CardIconEntry("cobblemon.species.mewtwo.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/150mewtwo"), 13418726, 10840219), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/150mewtwoshiny"), 15987426, 8896376))));
        this.values.put("151mew", new CardIconEntry("cobblemon.species.mew.name", Map.of("*", new CardIconEntry.Entry(StarAcademyMod.id("card/icon/151mew"), 0xFFBFB8, 12291729), CardRarity.SHINY.name(), new CardIconEntry.Entry(StarAcademyMod.id("card/icon/151mewshiny"), 12117759, 7190751))));
    }
}

