/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config;

import abeshutt.staracademy.config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class RegistryConfig<T>
extends Config {
    private Map<Path, T> pathToValue = new HashMap<Path, T>();
    private Map<String, T> idToValue = new HashMap<String, T>();

    public abstract String getFolder();

    public abstract Type getType();

    public abstract void process(String var1, T var2);

    public Map<String, T> getAll() {
        return this.idToValue;
    }

    public void put(String path, T value) {
        this.pathToValue.put(Paths.get(path.replace("/", File.separator) + ".json", new String[0]), value);
        this.idToValue.put(path, value);
    }

    public Optional<T> get(String path) {
        return Optional.ofNullable(this.idToValue.get(path));
    }

    private Path getFolderFile() {
        return Path.of("config", "academy", this.getFolder());
    }

    @Override
    public void write() throws IOException {
        this.pathToValue.forEach((path, value) -> {
            try {
                Path out = this.getFolderFile().resolve((Path)path);
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                this.writeFile(out, value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public <C extends Config> C read() {
        Path folder = this.getFolderFile();
        if (Files.isDirectory(folder, new LinkOption[0])) {
            try {
                Files.find(folder, 100, (path, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]).forEach(path -> {
                    try {
                        Object value = this.readFile((Path)path, this.getType());
                        path = folder.relativize((Path)path);
                        String id = path.toString().replace(File.separator, "/");
                        id = id.substring(0, id.lastIndexOf("."));
                        this.process(id, value);
                        this.pathToValue.put((Path)path, (T)value);
                        this.idToValue.put(id, value);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.reset();
            try {
                this.write();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (C)this;
    }
}

