/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.config.sound.PlaySoundEvent;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.biome.BiomePredicate;
import abeshutt.staracademy.data.entity.EntityPredicate;
import abeshutt.staracademy.data.item.ItemPredicate;
import abeshutt.staracademy.data.tile.TilePredicate;
import abeshutt.staracademy.item.data.card.BoosterPackEntry;
import abeshutt.staracademy.item.data.card.CardAlbumEntry;
import abeshutt.staracademy.item.data.card.CardDisplayEntry;
import abeshutt.staracademy.item.data.card.CardEntry;
import abeshutt.staracademy.item.data.card.CardIconEntry;
import abeshutt.staracademy.item.data.card.CardModifierEntry;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.roll.IntRoll;
import abeshutt.staracademy.util.ItemUseLogic;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public abstract class Config {
    protected static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().setLenient().registerTypeHierarchyAdapter(TilePredicate.class, (Object)Adapters.TILE_PREDICATE).registerTypeHierarchyAdapter(EntityPredicate.class, (Object)Adapters.ENTITY_PREDICATE).registerTypeHierarchyAdapter(ItemPredicate.class, (Object)Adapters.ITEM_PREDICATE).registerTypeHierarchyAdapter(BiomePredicate.class, (Object)Adapters.BIOME_PREDICATE).registerTypeHierarchyAdapter(IntRoll.class, (Object)Adapters.INT_ROLL).registerTypeHierarchyAdapter(PlaySoundEvent.class, (Object)PlaySoundEvent.Adapter.INSTANCE).registerTypeAdapter(class_2338.class, (Object)Adapters.BLOCK_POS).registerTypeAdapter(class_2960.class, (Object)Adapters.IDENTIFIER).registerTypeAdapter(class_1799.class, (Object)Adapters.ITEM_STACK).registerTypeAdapter(ItemUseLogic.class, Adapters.of(ItemUseLogic::new, false)).registerTypeAdapter(Rational.class, (Object)Adapters.RATIONAL).registerTypeAdapter(CardEntry.class, Adapters.CARD_ENTRY).registerTypeAdapter(CardIconEntry.class, Adapters.CARD_ICON_ENTRY).registerTypeAdapter(CardModifierEntry.class, Adapters.CARD_MODIFIER_ENTRY).registerTypeAdapter(BoosterPackEntry.class, Adapters.CARD_BOOSTER_ENTRY).registerTypeAdapter(CardAlbumEntry.class, Adapters.CARD_ALBUM_ENTRY).registerTypeAdapter(CardDisplayEntry.class, Adapters.CARD_DISPLAY_ENTRY).registerTypeAdapter(Attribute.class, (Object)Adapters.ATTRIBUTE).create();

    public abstract void write() throws IOException;

    public abstract <C extends Config> C read() throws IOException;

    protected abstract void reset();

    protected final void writeFile(Path path, Object file) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        FileWriter writer = new FileWriter(path.toFile());
        GSON.toJson(file, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    protected final <C> C readFile(Path path, Type type) throws FileNotFoundException {
        return (C)GSON.fromJson((Reader)new FileReader(path.toFile()), type);
    }
}

