/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.command;

import abeshutt.staracademy.command.Command;
import abeshutt.staracademy.init.ModDataComponents;
import abeshutt.staracademy.init.ModItems;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.world.data.AcademyHouse;
import abeshutt.staracademy.world.data.save.HouseData;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.architectury.hooks.item.ItemStackHooks;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_9331;

public class HouseCommand
extends Command {
    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"academy").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"house").requires(source2 -> source2.method_9259(4))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(this::onCreateHouse)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(this::getHouseSuggestions).executes(this::onRemoveHouse)))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(this::getHouseSuggestions).then(class_2170.method_9247((String)"add_player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(this::onAddPlayer)))).then(class_2170.method_9247((String)"remove_player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(this::onRemovePlayer)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::onSetName))).executes(this::onGetName))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"color", (ArgumentType)IntegerArgumentType.integer()).executes(this::onSetColor))).executes(this::onGetColor))))).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(this::getHouseSuggestions).executes(this::onHouseInvite))))));
    }

    private int onGetName(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)" has name '").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"'.").method_27692(class_124.field_1080)), false);
        return 0;
    }

    private int onSetName(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        String name = StringArgumentType.getString(context, (String)"name");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        String oldName = house.getName();
        house.setName(name);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)oldName).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)" name was changed to '").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"'.").method_27692(class_124.field_1080)), false);
        return 0;
    }

    private int onGetColor(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)" has color ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + house.getColor())).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        return 0;
    }

    private int onSetColor(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        int color = IntegerArgumentType.getInteger(context, (String)"color");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        int oldColor = house.getColor();
        house.setColor(color);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(oldColor))).method_10852((class_2561)class_2561.method_43470((String)" color was changed to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + house.getColor())).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        return 0;
    }

    private int onAddPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        Collection players = class_2191.method_9330(context, (String)"player");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        for (GameProfile player : players) {
            if (house.addPlayer(player.getId())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Added ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)player.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
                continue;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)player.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is already in ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        }
        return 0;
    }

    private int onRemovePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        Collection players = class_2191.method_9330(context, (String)"player");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.get(id).orElse(null);
        if (house == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"House ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)id).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" does not exist.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        for (GameProfile player : players) {
            if (house.removePlayer(player.getId())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Removed ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)player.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" from ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
                continue;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)player.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is absent from ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        }
        return 0;
    }

    private int onCreateHouse(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        String name = StringArgumentType.getString(context, (String)"name");
        int color = IntegerArgumentType.getInteger(context, (String)"color");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        data.add(id, name, color);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Created house ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)name).method_10862(class_2583.field_24360.method_36139(color))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        return 0;
    }

    private int onRemoveHouse(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        AcademyHouse house = data.remove(id);
        if (house != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Removed house ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)house.getName()).method_10862(class_2583.field_24360.method_36139(house.getColor()))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
        }
        return 0;
    }

    private int onHouseInvite(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2191.method_9330(context, (String)"player");
        String id = StringArgumentType.getString(context, (String)"id");
        for (GameProfile profile : players) {
            class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(profile.getId());
            if (player == null) continue;
            class_1799 stack = new class_1799((class_1935)ModItems.ACCEPTANCE_LETTER.get());
            stack.method_57379((class_9331)ModDataComponents.ACCEPTANCE_LETTER_OWNER.get(), (Object)player.method_5667());
            stack.method_57379((class_9331)ModDataComponents.ACCEPTANCE_LETTER_HOUSE.get(), (Object)id);
            for (class_3222 other : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                other.method_43496((class_2561)class_2561.method_43473().method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has received a letter from the Academy...").method_27692(class_124.field_1080)));
            }
            ItemStackHooks.giveItem((class_3222)player, (class_1799)stack);
        }
        return 0;
    }

    private CompletableFuture<Suggestions> getHouseSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        HouseData data = ModWorldData.HOUSE.getGlobal(((class_2168)context.getSource()).method_9211());
        return class_2172.method_9264(data.getHouses().values().stream().map(AcademyHouse::getId), (SuggestionsBuilder)builder);
    }
}

