/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.block.entity.renderer;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.util.ClientScheduler;
import abeshutt.staracademy.util.ColorBlender;
import dev.architectury.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_8614;
import net.minecraft.class_9224;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class DynamicResourcePack
extends class_3255 {
    private final ZipFileWrapper zipFile;
    private final String overlay;

    public DynamicResourcePack(class_9224 info, ZipFileWrapper zipFile, String overlay) {
        super(info);
        this.zipFile = zipFile;
        this.overlay = overlay;
    }

    public static void open(class_3264 type, class_5352 source2, TriConsumer<Path, class_3288.class_7680, class_9224> callback) {
        try {
            Path root = class_310.method_1551().field_1697.toPath().toRealPath(new LinkOption[0]);
            Path cache = root.resolve("codex").toRealPath(new LinkOption[0]);
            Path resources = cache.resolve(type.method_14413() + ".zip").toRealPath(new LinkOption[0]);
            class_9224 info = new class_9224("Academy Runtime", (class_2561)class_2561.method_43470((String)"Academy Runtime"), source2, Optional.empty()){

                public class_2561 comp_2330() {
                    double time = 0.0;
                    if (Platform.getEnv() == EnvType.CLIENT) {
                        time = ClientScheduler.getTick(class_310.method_1551().method_60646().method_60637(true));
                    }
                    return DynamicResourcePack.styleText("\u02d7\u02cf\u02cb\ua4b0\u2728 Academy Codex \u2728\ua4b1\u02ce\u02ca\u02d7", time, 10.0f);
                }
            };
            callback.accept((Object)resources, (Object)new ZipBackedFactory(resources), (Object)info);
        }
        catch (IOException e) {
            StarAcademyMod.LOGGER.error("Failed to open cached %s.".formatted(type.name()), (Throwable)e);
        }
    }

    private static class_2561 styleText(String string, double time, float offset) {
        class_5250 text = class_2561.method_43473();
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            text = text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_10862(class_2583.field_24360.method_36139(DynamicResourcePack.getColor(time + (double)((float)count * offset)).intValue())));
            if (c == ' ') continue;
            ++count;
        }
        return text;
    }

    public static Integer getColor(double time) {
        ColorBlender blender = new ColorBlender(1.5f).add(16024470, 250.0f).add(8832507, 250.0f);
        return blender.getColor(time);
    }

    private static String toPath(class_3264 type, class_2960 id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.method_14413(), id.method_12836(), id.method_12832());
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... segments) {
        return this.openFile(String.join((CharSequence)"/", segments));
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        return this.openFile(DynamicResourcePack.toPath(type, id));
    }

    private String appendOverlayPrefix(String path) {
        return this.overlay.isEmpty() ? path : this.overlay + "/" + path;
    }

    @Nullable
    private class_7367<InputStream> openFile(String path) {
        ZipFile zipFile = this.zipFile.open();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(this.appendOverlayPrefix(path));
        return zipEntry == null ? null : class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry);
    }

    public Set<String> method_14406(class_3264 type) {
        ZipFile zipFile = this.zipFile.open();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet<String> namespaces = new HashSet<String>();
        String prefix = this.appendOverlayPrefix(type.method_14413() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            String namespace = DynamicResourcePack.getNamespace(prefix, name);
            if (namespace.isEmpty()) continue;
            if (class_2960.method_20209((String)namespace)) {
                namespaces.add(namespace);
                continue;
            }
            StarAcademyMod.LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring.", (Object)namespace, (Object)this.zipFile.file);
        }
        return namespaces;
    }

    public static String getNamespace(String prefix, String entryName) {
        if (!entryName.startsWith(prefix)) {
            return "";
        }
        int length = prefix.length();
        int divider = entryName.indexOf(47, length);
        return divider == -1 ? entryName.substring(length) : entryName.substring(length, divider);
    }

    public void close() {
        this.zipFile.close();
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        ZipFile zipFile = this.zipFile.open();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            String header = this.appendOverlayPrefix(type.method_14413() + "/" + namespace + "/");
            String path = header + prefix + "/";
            while (enumeration.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(name = zipEntry.getName()).startsWith(path)) continue;
                String stripped = name.substring(header.length());
                class_2960 identifier = class_2960.method_43902((String)namespace, (String)stripped);
                if (identifier != null) {
                    consumer.accept((Object)identifier, (Object)class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry));
                    continue;
                }
                StarAcademyMod.LOGGER.warn("Invalid path in pack: {}:{}, ignoring.", (Object)namespace, (Object)stripped);
            }
        }
    }

    public static class ZipFileWrapper
    implements AutoCloseable {
        final File file;
        private ZipFile zip;
        private boolean closed;

        public ZipFileWrapper(File file) {
            this.file = file;
        }

        @Nullable
        public ZipFile open() {
            if (this.closed) {
                return null;
            }
            if (this.zip == null) {
                try {
                    this.zip = new ZipFile(this.file);
                }
                catch (IOException var2) {
                    StarAcademyMod.LOGGER.error("Failed to open pack {}.", (Object)this.file, (Object)var2);
                    this.closed = true;
                    return null;
                }
            }
            return this.zip;
        }

        @Override
        public void close() {
            if (this.zip != null) {
                IOUtils.closeQuietly((Closeable)this.zip);
                this.zip = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class ZipBackedFactory
    implements class_3288.class_7680 {
        private final File file;

        public ZipBackedFactory(Path path) {
            this(path.toFile());
        }

        public ZipBackedFactory(File file) {
            this.file = file;
        }

        public class_3262 method_52424(class_9224 info) {
            ZipFileWrapper zipFileWrapper = new ZipFileWrapper(this.file);
            return new DynamicResourcePack(info, zipFileWrapper, "");
        }

        public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
            ZipFileWrapper zipFileWrapper = new ZipFileWrapper(this.file);
            DynamicResourcePack resourcePack = new DynamicResourcePack(info, zipFileWrapper, "");
            List overlays = metadata.comp_1584();
            if (overlays.isEmpty()) {
                return resourcePack;
            }
            ArrayList<DynamicResourcePack> copy = new ArrayList<DynamicResourcePack>(overlays.size());
            for (String string : overlays) {
                copy.add(new DynamicResourcePack(info, zipFileWrapper, string));
            }
            return new class_8614((class_3262)resourcePack, copy);
        }
    }
}

