/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.block.entity.renderer;

import abeshutt.staracademy.block.entity.renderer.DynamicBone;
import abeshutt.staracademy.block.entity.renderer.DynamicTexture;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5610;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

public class DynamicOutfit {
    private static final String[] BASE_PARTS = new String[]{"head", "hat", "body", "right_arm", "right_leg", "right_sleeve", "right_pants", "left_arm", "left_leg", "left_sleeve", "left_pants", "ear", "cloak", "jacket"};
    public final String name;
    public final class_1091 icon;
    public final DynamicTexture classicTexture;
    public final DynamicBone classicMesh;
    public final DynamicTexture slimTexture;
    public final DynamicBone slimMesh;

    public DynamicOutfit(String name, class_1091 icon, DynamicTexture classicTexture, DynamicBone classicMesh, DynamicTexture slimTexture, DynamicBone slimMesh) {
        this.name = name;
        this.icon = icon;
        this.classicTexture = classicTexture;
        this.classicMesh = classicMesh;
        this.slimTexture = slimTexture;
        this.slimMesh = slimMesh;
    }

    public class_2960 getTexture(boolean slim) {
        return slim ? this.slimTexture.id : this.classicTexture.id;
    }

    @Environment(value=EnvType.CLIENT)
    public class_591<class_742> getModel(class_5617.class_5618 ctx, boolean slim) {
        DynamicTexture texture = slim ? this.slimTexture : this.classicTexture;
        DynamicBone mesh = slim ? this.slimMesh : this.classicMesh;
        class_5610 root = mesh.build();
        for (String name : BASE_PARTS) {
            if (root.method_32116(name) != null) continue;
            root.method_32117(name, class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        }
        class_630 model = root.method_32112(texture.width, texture.height);
        return new class_591(model, slim);
    }

    public static class Adapter
    implements ISimpleAdapter<DynamicOutfit, class_2520, JsonElement> {
        @Override
        public Optional<JsonElement> writeJson(DynamicOutfit value) {
            return Optional.of(new JsonObject()).map(object -> {
                Adapters.UTF_8.writeJson(value.name).ifPresent(tag -> object.add("name", tag));
                Adapters.MODEL_IDENTIFIER.writeJson(value.icon).ifPresent(tag -> object.add("icon", tag));
                JsonObject classic = new JsonObject();
                Adapters.DYNAMIC_TEXTURE.writeJson(value.classicTexture).ifPresent(tag -> classic.add("texture", tag));
                Adapters.DYNAMIC_BONE.writeJson(value.classicMesh).ifPresent(tag -> classic.add("mesh", tag));
                object.add("classic", (JsonElement)classic);
                JsonObject slim = new JsonObject();
                Adapters.DYNAMIC_TEXTURE.writeJson(value.slimTexture).ifPresent(tag -> slim.add("texture", tag));
                Adapters.DYNAMIC_BONE.writeJson(value.slimMesh).ifPresent(tag -> slim.add("mesh", tag));
                object.add("slim", (JsonElement)slim);
                return object;
            });
        }

        @Override
        public Optional<DynamicOutfit> readJson(JsonElement json) {
            if (!(json instanceof JsonObject)) {
                return Optional.empty();
            }
            JsonObject object = (JsonObject)json;
            JsonObject classic = object.getAsJsonObject("classic");
            JsonObject slim = object.getAsJsonObject("slim");
            if (classic == null && slim != null) {
                classic = slim;
            } else if (classic != null && slim == null) {
                slim = classic;
            }
            if (classic == null) {
                throw new NullPointerException();
            }
            return Optional.of(new DynamicOutfit(Adapters.UTF_8.readJson(object.get("name")).orElseThrow(), Adapters.MODEL_IDENTIFIER.readJson(object.get("icon")).orElseThrow(), Adapters.DYNAMIC_TEXTURE.readJson(classic.get("texture")).orElseThrow(), Adapters.DYNAMIC_BONE.readJson(classic.get("mesh")).orElseThrow(), Adapters.DYNAMIC_TEXTURE.readJson(slim.get("texture")).orElseThrow(), Adapters.DYNAMIC_BONE.readJson(slim.get("mesh")).orElseThrow()));
        }
    }
}

