/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute.type;

import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.attribute.type.NumberAttributeType;
import java.util.ArrayList;

public abstract class AttributeType<T> {
    protected AttributeType() {
    }

    public abstract int toBitMask();

    public AttributeType<?> simplify() {
        int mask = this.toBitMask();
        ArrayList<NumberAttributeType> parts = new ArrayList<NumberAttributeType>();
        for (int i = 0; i < 32; ++i) {
            int child = 1 << i;
            if ((mask & child) == 0) continue;
            parts.add((NumberAttributeType)(switch (child) {
                case 1 -> AttributeTypes.number();
                default -> AttributeTypes.never();
            }));
        }
        if (parts.isEmpty()) {
            return AttributeTypes.never();
        }
        if (parts.size() == 1) {
            return (AttributeType)parts.getFirst();
        }
        return AttributeTypes.union(parts.toArray(new AttributeType[0]));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeType) {
            AttributeType other = (AttributeType)obj;
            return this.toBitMask() == other.toBitMask();
        }
        return false;
    }
}

