/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute.path;

import abeshutt.staracademy.data.serializable.ISerializable;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class AttributePath<U>
implements ISerializable<class_2520, JsonElement> {
    private boolean absolute;
    private final List<String> parts;

    protected AttributePath() {
        this.absolute = false;
        this.parts = new ArrayList<String>();
    }

    protected AttributePath(boolean absolute, String ... parts) {
        this.absolute = absolute;
        this.parts = new ArrayList<String>(Arrays.asList(parts));
    }

    protected AttributePath(boolean absolute, List<String> folder) {
        this.absolute = absolute;
        this.parts = folder;
    }

    public static <T> AttributePath<T> empty() {
        return new AttributePath(false, new String[0]);
    }

    public static <T> AttributePath<T> absolute(String ... parts) {
        return new AttributePath(true, parts);
    }

    public static <T> AttributePath<T> relative(String ... parts) {
        return new AttributePath(false, parts);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public AttributePath<U> toRelative() {
        return new AttributePath<U>(false, this.parts);
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public <T> T split(BiFunction<String, AttributePath<U>, T> action) {
        if (this.parts.size() == 1) {
            return action.apply(this.parts.getFirst(), AttributePath.empty());
        }
        return action.apply(this.parts.getFirst(), new AttributePath<U>(false, this.parts.subList(1, this.parts.size())));
    }

    @Override
    public Optional<class_2520> writeNbt() {
        if (!this.absolute && this.parts.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(this.absolute ? "/" : "");
        for (int i = 0; i < this.parts.size(); ++i) {
            String folder = this.parts.get(i);
            builder.append(folder);
            if (i == this.parts.size() - 1) continue;
            builder.append("/");
        }
        return Optional.of(class_2519.method_23256((String)builder.toString()));
    }

    @Override
    public void readNbt(class_2520 nbt) {
        this.parts.clear();
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            String path = string.method_10714();
            if (path.startsWith("/")) {
                path = path.substring(1);
                this.absolute = true;
            } else {
                this.absolute = false;
            }
            String[] parts = path.split("/");
            this.parts.addAll(Arrays.asList(parts));
        }
    }

    @Override
    public Optional<JsonElement> writeJson() {
        if (!this.absolute && this.parts.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(this.absolute ? "/" : "");
        for (int i = 0; i < this.parts.size(); ++i) {
            String folder = this.parts.get(i);
            builder.append(folder);
            if (i == this.parts.size() - 1) continue;
            builder.append("/");
        }
        return Optional.of(new JsonPrimitive(builder.toString()));
    }

    @Override
    public void readJson(JsonElement json) {
        JsonPrimitive primitive;
        this.parts.clear();
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            String path = primitive.getAsString();
            if (path.startsWith("/")) {
                path = path.substring(1);
                this.absolute = true;
            } else {
                this.absolute = false;
            }
            String[] parts = path.split("/");
            this.parts.addAll(Arrays.asList(parts));
        }
    }
}

