/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.data.adapter.Adapters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NodeAttribute<T>
extends Attribute<T> {
    protected Map<Object, List<Modifier<T>>> keyedListeners = new HashMap<Object, List<Modifier<T>>>();
    protected List<Modifier<T>> orderedModifiers = new ArrayList<Modifier<T>>();

    protected NodeAttribute(AttributeType<T> type) {
        super(type);
    }

    public static <T> NodeAttribute<T> of(AttributeType<T> type) {
        return new NodeAttribute<T>(type);
    }

    public List<Modifier<T>> getModifiers() {
        return this.orderedModifiers;
    }

    public NodeAttribute<T> add(Modifier<T> modifier) {
        int index;
        List keyed = this.keyedListeners.computeIfAbsent(modifier.getOwner(), key -> new ArrayList());
        keyed.add(modifier);
        List<Modifier<T>> ordered = this.orderedModifiers;
        if (index >= 0) {
            for (index = Collections.binarySearch(ordered, modifier); index < ordered.size() - 1 && ordered.get(index + 1).compareTo(modifier) == 0; ++index) {
            }
            ++index;
        } else {
            index = -index - 1;
        }
        ordered.add(index, modifier);
        modifier.getAttribute().setParent(this);
        return this;
    }

    public NodeAttribute<T> add(Object owner, int order, Attribute<T> attribute) {
        return this.add(new Modifier<T>(owner, order, attribute));
    }

    public NodeAttribute<T> remove(Object owner) {
        List<Modifier<T>> listeners = this.keyedListeners.remove(owner);
        if (listeners == null || listeners.isEmpty()) {
            return this;
        }
        this.orderedModifiers.removeAll(new HashSet<Modifier<T>>(listeners));
        for (Modifier<T> listener : listeners) {
            listener.getAttribute().setParent(null);
        }
        return this;
    }

    @Override
    public Option<T> get(Option<T> value, AttributeContext context) {
        for (Modifier<T> modifier : this.orderedModifiers) {
            value = modifier.getAttribute().get(value, context);
        }
        return value;
    }

    @Override
    public void populate(AttributeContext context) {
        for (Modifier<T> modifier : this.orderedModifiers) {
            modifier.getAttribute().populate(context);
        }
        super.populate(context);
    }

    @Override
    public void iterate(Consumer<Attribute<?>> action) {
        super.iterate(action);
        for (Modifier<T> modifier : this.orderedModifiers) {
            modifier.getAttribute().iterate(action);
        }
    }

    @Override
    public Optional<class_2520> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                class_2499 modifiers = new class_2499();
                for (Modifier<T> modifier : this.orderedModifiers) {
                    modifier.writeNbt(this.type).ifPresent(arg_0 -> modifiers.add(arg_0));
                }
                compound.method_10566("modifiers", (class_2520)modifiers);
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2520 nbt) {
        class_2487 compound;
        class_2520 class_25202;
        super.readNbt(nbt);
        this.orderedModifiers.clear();
        if (nbt instanceof class_2487 && (class_25202 = (compound = (class_2487)nbt).method_10580("modifiers")) instanceof class_2499) {
            class_2499 list = (class_2499)class_25202;
            for (int i = 0; i < list.size(); ++i) {
                class_2487 element = list.method_10602(i);
                Modifier modifier = new Modifier();
                modifier.readNbt(element, this.type);
                this.add(modifier);
            }
        }
    }

    public static class Modifier<T>
    implements Comparable<Modifier<T>> {
        private Object owner;
        private int order;
        private Attribute<?> attribute;

        protected Modifier() {
            this(null, 0, null);
        }

        public Modifier(Object owner, int order, Attribute<T> attribute) {
            this.owner = owner;
            this.order = order;
            this.attribute = attribute;
        }

        public Object getOwner() {
            return this.owner;
        }

        public int getOrder() {
            return this.order;
        }

        public Attribute<T> getAttribute() {
            return this.attribute;
        }

        public Optional<class_2487> writeNbt(AttributeType<?> context) {
            return Adapters.ATTRIBUTE.writeNbt(this.attribute, context).map(tag -> {
                if (tag instanceof class_2487) {
                    class_2487 compound = (class_2487)tag;
                    if (this.order != 0) {
                        Adapters.INT.writeNbt(this.order).ifPresent(e -> compound.method_10566("order", e));
                    }
                    return compound;
                }
                class_2487 wrapper = new class_2487();
                wrapper.method_10566("attribute", tag);
                Adapters.INT.writeNbt(this.order).ifPresent(e -> wrapper.method_10566("order", e));
                return wrapper;
            });
        }

        public void readNbt(class_2487 nbt, AttributeType<?> context) {
            this.order = Adapters.INT.readNbt(nbt.method_10580("order")).orElse(0);
            class_2487 attribute = nbt;
            if (nbt.method_10545("attribute")) {
                attribute = nbt.method_10580("attribute");
            }
            this.attribute = Adapters.ATTRIBUTE.readNbt((class_2520)attribute, context).orElseThrow();
        }

        @Override
        public int compareTo(Modifier<T> other) {
            return Integer.compare(this.order, other.getOrder());
        }
    }
}

