/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class ConfigAttribute<T, C>
extends Attribute<T> {
    private C config;
    private boolean populated;

    protected ConfigAttribute(AttributeType<T> type, C config) {
        super(type);
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    @Override
    public void populate(AttributeContext context) {
        if (!this.populated) {
            this.generate(context);
            this.populated = true;
        }
        super.populate(context);
    }

    protected abstract void generate(AttributeContext var1);

    protected abstract void writeBaseBits(BitBuffer var1);

    protected abstract void readBaseBits(BitBuffer var1);

    protected abstract void writeBaseNbt(class_2487 var1);

    protected abstract void readBaseNbt(class_2487 var1);

    protected abstract void writeBaseJson(JsonObject var1);

    protected abstract void readBaseJson(JsonObject var1);

    protected abstract IAdapter<C, class_2520, JsonElement, ?> getConfigAdapter();

    @Override
    public final void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
        if (this.populated) {
            this.writeBaseBits(buffer);
        }
        this.getConfigAdapter().writeBits(this.config, buffer, null);
    }

    @Override
    public final void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
            this.readBaseBits(buffer);
        }
        this.config = this.getConfigAdapter().readBits(buffer, null).orElse(null);
    }

    @Override
    public final Optional<class_2520> writeNbt() {
        if (!this.populated) {
            return this.getConfigAdapter().writeNbt(this.config, null);
        }
        class_2487 nbt = new class_2487();
        this.writeBaseNbt(nbt);
        nbt.method_10566("config", this.getConfigAdapter().writeNbt(this.config, null).orElseThrow());
        return Optional.of(nbt);
    }

    @Override
    public final void readNbt(class_2520 nbt) {
        class_2487 object;
        super.readNbt(nbt);
        if (nbt instanceof class_2487 && (object = (class_2487)nbt).method_10545("config")) {
            this.readBaseNbt(object);
            this.config = this.getConfigAdapter().readNbt(object.method_10580("config"), null).orElseThrow();
            this.populated = true;
        } else {
            this.config = this.getConfigAdapter().readNbt(nbt, null).orElseThrow();
            this.populated = false;
        }
    }

    @Override
    public final Optional<JsonElement> writeJson() {
        if (!this.populated) {
            return this.getConfigAdapter().writeJson(this.config, null);
        }
        JsonObject json = new JsonObject();
        this.writeBaseJson(json);
        json.add("config", this.getConfigAdapter().writeJson(this.config, null).orElseThrow());
        return Optional.of(json);
    }

    @Override
    public final void readJson(JsonElement json) {
        JsonObject object;
        super.readJson(json);
        if (json instanceof JsonObject && (object = (JsonObject)json).has("config")) {
            this.readBaseJson(object);
            this.config = this.getConfigAdapter().readJson(object.get("config"), null).orElseThrow();
            this.populated = true;
        } else {
            this.config = this.getConfigAdapter().readJson(json, null).orElseThrow();
            this.populated = false;
        }
    }
}

