/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.attribute.type.NumberAttributeType;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.math.Rational;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class CardScalarAttribute<T>
extends Attribute<T> {
    private String id;
    private int grade;

    protected CardScalarAttribute(AttributeType<T> type) {
        super(type);
    }

    protected CardScalarAttribute(AttributeType<T> type, String id) {
        super(type);
        this.id = id;
    }

    public static CardScalarAttribute<Rational> of(String id) {
        return new CardScalarAttribute<Rational>(AttributeTypes.number(), id);
    }

    public CardScalarAttribute<T> setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public Option<Rational> getScalar() {
        List scalars = ModConfigs.CARD_SCALARS.get(this.id).orElse(new ArrayList());
        int index = this.grade - 1;
        if (index < 0 || index >= scalars.size()) {
            return Option.absent();
        }
        return Option.present((Rational)scalars.get(index));
    }

    @Override
    public Option<T> get(Option<T> value, AttributeContext context) {
        if (value.isAbsent()) {
            return Option.absent();
        }
        return value.map(a -> {
            Option<Rational> b;
            if (this.type instanceof NumberAttributeType && (b = this.getScalar()).isPresent()) {
                return ((Rational)a).multiply(b.get());
            }
            return value.get();
        });
    }

    @Override
    public Optional<class_2520> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                Adapters.UTF_8.writeNbt(this.id).ifPresent(tag -> compound.method_10566("id", tag));
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2520 nbt) {
        super.readNbt(nbt);
        if (!(nbt instanceof class_2487)) {
            throw new UnsupportedOperationException();
        }
        class_2487 compound = (class_2487)nbt;
        this.id = Adapters.UTF_8.readNbt(compound.method_10580("id")).orElseThrow();
    }

    @Override
    public Attribute<T> copy() {
        Attribute copy = super.copy();
        if (copy instanceof CardScalarAttribute) {
            CardScalarAttribute other = (CardScalarAttribute)copy;
            other.setGrade(this.grade);
        }
        return copy;
    }
}

