/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.NodeAttribute;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.path.AttributePath;
import abeshutt.staracademy.data.component.CardAlbumInventory;
import abeshutt.staracademy.event.CommonEvents;
import abeshutt.staracademy.init.ModDataComponents;
import abeshutt.staracademy.item.CardAlbumItem;
import abeshutt.staracademy.item.CardItem;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.random.JavaRandom;
import abeshutt.staracademy.proxy.AttributeHolder;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class Attributes {
    public static final AttributePath<Rational> SHINY_CHANCE = AttributePath.absolute("shiny_chance");
    public static final AttributePath<Rational> CAPTURE_FRIENDSHIP = AttributePath.absolute("capture_friendship");
    public static final AttributePath<Rational> CAPTURE_EXPERIENCE = AttributePath.absolute("capture_experience");
    public static final AttributePath<Rational> CAPTURE_CHANCE = AttributePath.absolute("capture_chance");

    public static AttributePath<Rational> ofBucketWeight(String name) {
        return AttributePath.absolute("bucket_weight", name);
    }

    public static AttributePath<Rational> ofLabelWeight(String name) {
        return AttributePath.absolute("label_weight", name);
    }

    public static AttributePath<Rational> ofEVYield(Stat stat) {
        return AttributePath.absolute("ev_yield", stat.getIdentifier().toString());
    }

    public static AttributePath<Rational> ofVanilla(class_6880<class_1320> attribute, class_1322.class_1323 operation) {
        return AttributePath.absolute("vanilla", attribute.method_55840(), operation.method_15434());
    }

    public static void init() {
        CommonEvents.POKEMON_CAPTURED.register(event -> {
            int friendship;
            int current = event.getPokemon().getFriendship();
            if (current != (friendship = AttributeHolder.getRoot(event.getPlayer()).path(CAPTURE_FRIENDSHIP).map(attribute -> {
                Option<Rational> result = attribute.get(Option.present(Rational.of(current)), AttributeContext.random());
                if (result.isPresent()) {
                    JavaRandom random = JavaRandom.ofNanoTime();
                    double raw = result.get().doubleValue();
                    int floored = (int)raw;
                    return floored + (random.nextDouble() >= raw - (double)floored ? 1 : 0);
                }
                return current;
            }).orElse(current).intValue())) {
                event.getPokemon().setFriendship(friendship, true);
            }
        }, Priority.LOWEST);
        CommonEvents.POKEMON_EXPERIENCE_GAINED_PRE.register(event -> {
            int experience;
            class_1309 entity = event.getPokemon().getOwnerEntity();
            if (entity == null) {
                return;
            }
            int current = event.getExperience();
            if (current != (experience = AttributeHolder.getRoot(entity).path(CAPTURE_EXPERIENCE).map(attribute -> {
                Option<Rational> result = attribute.get(Option.present(Rational.of(current)), AttributeContext.random());
                if (result.isPresent()) {
                    JavaRandom random = JavaRandom.ofNanoTime();
                    double raw = result.get().doubleValue();
                    int floored = (int)raw;
                    return floored + (random.nextDouble() >= raw - (double)floored ? 1 : 0);
                }
                return current;
            }).orElse(current).intValue())) {
                event.setExperience(experience);
            }
        }, Priority.LOWEST);
        CommonEvents.POKEMON_CATCH_RATE.register(event -> {
            float rate;
            class_1309 entity = event.getThrower();
            float current = event.getCatchRate();
            if (current != (rate = AttributeHolder.getRoot(entity).path(CAPTURE_CHANCE).map(attribute -> {
                Option<Rational> result = attribute.get(Option.present(Rational.of(current)), AttributeContext.random());
                return Float.valueOf(result.isPresent() ? result.get().floatValue() : current);
            }).orElse(Float.valueOf(current)).floatValue())) {
                event.setCatchRate(rate);
            }
        }, Priority.LOWEST);
        CommonEvents.PLAYER_TICK.register(player -> {
            if (player.method_37908().method_8608()) {
                return;
            }
            Attribute<?> root = AttributeHolder.getRoot(player);
            root.iterate(child -> {
                if (child instanceof NodeAttribute) {
                    NodeAttribute node = (NodeAttribute)child;
                    node.remove(CardAlbumItem.REFERENCE);
                }
            });
            TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> {
                Map legs = (Map)trinkets.getInventory().get("legs");
                if (legs == null) {
                    return;
                }
                TrinketInventory album = (TrinketInventory)legs.get("card_album");
                if (album == null || album.method_5442()) {
                    return;
                }
                class_1799 stack = album.method_5438(0);
                if (!(stack.method_7909() instanceof CardAlbumItem)) {
                    return;
                }
                CardAlbumInventory container = (CardAlbumInventory)stack.method_57824((class_9331)ModDataComponents.CARD_ALBUM_CONTAINER.get());
                if (container == null) {
                    return;
                }
                for (int i = 0; i < container.method_5439(); ++i) {
                    class_1799 card = container.method_5438(i);
                    if (card == null || !(card.method_7909() instanceof CardItem)) continue;
                    CardItem.get(card).ifPresent(data -> data.attach(root));
                }
            });
        });
    }
}

