/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.AddAttribute;
import abeshutt.staracademy.attribute.AssignAttribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.CardScalarAttribute;
import abeshutt.staracademy.attribute.MultiplyAttribute;
import abeshutt.staracademy.attribute.NodeAttribute;
import abeshutt.staracademy.attribute.NumberConstantAttribute;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.ReferenceAttribute;
import abeshutt.staracademy.attribute.ValueAttribute;
import abeshutt.staracademy.attribute.path.AttributePath;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.math.Rational;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public abstract class Attribute<T>
implements ISerializable<class_2520, JsonElement> {
    protected AttributeType<T> type;
    protected Attribute<?> parent;
    protected final Map<String, Attribute<?>> children;

    protected Attribute(AttributeType<T> type) {
        this.type = type;
        this.children = new HashMap();
    }

    public AttributeType<T> getType() {
        return this.type;
    }

    public Attribute<?> getParent() {
        return this.parent;
    }

    public void setParent(Attribute<?> parent) {
        this.parent = parent;
    }

    public Map<String, Attribute<?>> getChildren() {
        return this.children;
    }

    public abstract Option<T> get(Option<T> var1, AttributeContext var2);

    protected void narrow(AttributeType<T> type) {
    }

    public void populate(AttributeContext context) {
        this.children.forEach((name, attribute) -> attribute.populate(context));
    }

    public <U> Attribute<U> root() {
        Attribute<?> current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public <U> Optional<Attribute<U>> path(AttributePath<U> path) {
        if (path.isAbsolute()) {
            return this.root().path(path.toRelative());
        }
        if (!path.isEmpty()) {
            return path.split((part, remainder) -> {
                if (part.equals("..")) {
                    return this.getParent().path((AttributePath)remainder);
                }
                if (part.equals(".")) {
                    return this.path((AttributePath)remainder);
                }
                return Optional.ofNullable(this.getChildren().get(part)).flatMap(a -> a.path((AttributePath)remainder));
            });
        }
        return Optional.of(this);
    }

    public Attribute<?> addChild(String name, Attribute<?> attribute) {
        this.children.put(name, attribute);
        attribute.setParent(this);
        return this;
    }

    @Override
    public Optional<class_2520> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            this.children.forEach((name, attribute) -> Adapters.ATTRIBUTE.writeNbt((Attribute<?>)attribute, (AttributeType<?>)AttributeTypes.any()).ifPresent(tag -> nbt.method_10566("/" + name, tag)));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2520 nbt) {
        this.children.clear();
        if (!(nbt instanceof class_2487)) {
            return;
        }
        class_2487 compound = (class_2487)nbt;
        for (String key : compound.method_10541()) {
            if (!key.startsWith("/")) continue;
            String name = key.substring(1);
            Adapters.ATTRIBUTE.readNbt(compound.method_10580(key), (AttributeType<?>)AttributeTypes.any()).ifPresent(child -> {
                this.children.put(name, (Attribute<?>)child);
                child.setParent(this);
            });
        }
    }

    public void iterate(Consumer<Attribute<?>> action) {
        action.accept(this);
        this.children.forEach((s, attribute) -> attribute.iterate(action));
    }

    public Attribute<T> copy() {
        class_2520 nbt = Adapters.ATTRIBUTE.writeNbt(this, this.type).orElse(null);
        return Adapters.ATTRIBUTE.readNbt(nbt, this.type).orElseThrow();
    }

    public static class Adapter
    implements IAdapter<Attribute<?>, class_2520, JsonElement, AttributeType<?>> {
        @Override
        public void writeBits(Attribute<?> value, BitBuffer buffer, AttributeType<?> context) {
            Adapters.GENERIC_NBT.asNullable().writeBits(this.writeNbt(value, context).orElse(null), buffer);
        }

        @Override
        public Optional<Attribute<?>> readBits(BitBuffer buffer, AttributeType<?> context) {
            Optional<Object> nbt = Adapters.GENERIC_NBT.asNullable().readBits(buffer, context);
            return Adapters.ATTRIBUTE.readNbt((class_2520)nbt.orElse(null), context);
        }

        @Override
        public Optional<class_2520> writeNbt(Attribute<?> value, AttributeType<?> context) {
            if (value instanceof ReferenceAttribute) {
                return value.writeNbt();
            }
            Attribute<?> attribute = value;
            Objects.requireNonNull(attribute);
            Attribute<?> attribute2 = attribute;
            int n = 0;
            String type = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NodeAttribute.class, AssignAttribute.class, AddAttribute.class, MultiplyAttribute.class, CardScalarAttribute.class}, attribute2, n)) {
                case 0 -> {
                    NodeAttribute ignored = (NodeAttribute)attribute2;
                    yield "node";
                }
                case 1 -> {
                    AssignAttribute ignored = (AssignAttribute)attribute2;
                    yield "assign";
                }
                case 2 -> {
                    AddAttribute ignored = (AddAttribute)attribute2;
                    yield "add";
                }
                case 3 -> {
                    MultiplyAttribute ignored = (MultiplyAttribute)attribute2;
                    yield "multiply";
                }
                case 4 -> {
                    CardScalarAttribute ignored = (CardScalarAttribute)attribute2;
                    yield "card_scalar";
                }
                default -> null;
            };
            Optional<class_2520> element = value.writeNbt();
            return element.map(tag -> {
                if (tag instanceof class_2487) {
                    class_2487 compound = (class_2487)tag;
                    if (!(value instanceof ValueAttribute)) {
                        if (type != null) {
                            if (!type.equals("node") || !compound.method_10545("modifiers")) {
                                compound.method_10582("type", type);
                            }
                        } else {
                            throw new UnsupportedOperationException("Unknown attribute: " + value.getClass().getSimpleName());
                        }
                    }
                }
                return tag;
            });
        }

        @Override
        public Optional<Attribute<?>> readNbt(class_2520 nbt, AttributeType<?> context) {
            class_2519 string;
            context = context.simplify();
            Attribute attribute = null;
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                String type = Adapters.UTF_8.readNbt(compound.method_10580("type")).orElse(null);
                if (type == null && (compound.method_10545("modifiers") || compound.method_10541().stream().anyMatch(s -> s.startsWith("/")))) {
                    type = "node";
                }
                if ("add".equals(type) && AttributeTypes.intersection(context, AttributeTypes.number()).simplify().equals(AttributeTypes.number())) {
                    attribute = new AddAttribute<Rational>(AttributeTypes.number());
                } else if ("multiply".equals(type) && AttributeTypes.intersection(context, AttributeTypes.number()).simplify().equals(AttributeTypes.number())) {
                    attribute = new MultiplyAttribute<Rational>(AttributeTypes.number());
                } else if ("assign".equals(type) && context.equals(AttributeTypes.number())) {
                    attribute = new AssignAttribute(context);
                } else if ("node".equals(type)) {
                    attribute = new NodeAttribute(context);
                } else if ("card_scalar".equals(type)) {
                    attribute = new CardScalarAttribute(context);
                } else if (context.equals(AttributeTypes.number())) {
                    attribute = new NumberConstantAttribute();
                }
            } else if (nbt instanceof class_2519 && ((string = (class_2519)nbt).method_10714().startsWith("/") || string.method_10714().startsWith("./") || string.method_10714().startsWith("../"))) {
                attribute = new ReferenceAttribute(context, null);
            } else if (context.simplify().equals(AttributeTypes.number())) {
                attribute = new NumberConstantAttribute();
            }
            if (attribute != null) {
                ((Attribute)attribute).readNbt(nbt);
            }
            return Optional.ofNullable(attribute);
        }

        @Override
        public Optional<JsonElement> writeJson(Attribute<?> value, AttributeType<?> context) {
            return this.writeNbt(value, context).flatMap(tag -> Adapters.GENERIC_NBT.writeJson(tag, context));
        }

        @Override
        public Optional<Attribute<?>> readJson(JsonElement json, AttributeType<?> context) {
            return Adapters.GENERIC_NBT.readJson(json, context).flatMap(tag -> Adapters.ATTRIBUTE.readNbt((class_2520)tag, context));
        }

        @Override
        public JsonElement serialize(Attribute<?> value, Type source2, JsonSerializationContext context) {
            return this.writeJson(value, (AttributeType<?>)AttributeTypes.any()).orElse((JsonElement)JsonNull.INSTANCE);
        }

        @Override
        public Attribute<?> deserialize(JsonElement json, Type source2, JsonDeserializationContext context) {
            return this.readJson(json, (AttributeType<?>)AttributeTypes.any()).orElse(null);
        }
    }
}

