/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.attribute;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.NumberConstantAttribute;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.roll.NumberRoll;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class AssignAttribute<T>
extends Attribute<T> {
    private Attribute<T> value;

    protected AssignAttribute(AttributeType<T> type) {
        super(type);
    }

    protected AssignAttribute(AttributeType<T> type, Attribute<T> value) {
        super(type);
        this.value = value;
    }

    public static AssignAttribute<Rational> of(NumberRoll roll) {
        return new AssignAttribute<Rational>(AttributeTypes.number(), NumberConstantAttribute.of(roll));
    }

    public Attribute<T> getValue() {
        return this.value;
    }

    @Override
    public Option<T> get(Option<T> value, AttributeContext context) {
        Option<T> result = this.value.get(Option.absent(), context);
        if (result.isAbsent()) {
            return value;
        }
        return result;
    }

    @Override
    public void populate(AttributeContext context) {
        this.value.populate(context);
        super.populate(context);
    }

    @Override
    public void iterate(Consumer<Attribute<?>> action) {
        super.iterate(action);
        action.accept(this.value);
    }

    @Override
    public Optional<class_2520> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                Adapters.ATTRIBUTE.writeNbt(this.value, this.type).ifPresent(tag -> compound.method_10566("value", tag));
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2520 nbt) {
        super.readNbt(nbt);
        if (!(nbt instanceof class_2487)) {
            throw new UnsupportedOperationException();
        }
        class_2487 compound = (class_2487)nbt;
        this.value = Adapters.ATTRIBUTE.readNbt(compound.method_10580("value"), this.type).orElseThrow();
        this.value.setParent(this);
    }
}

