/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.api.AcademyPacket;
import abeshutt.staracademy.data.adapter.Adapters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class UpdateOutfitTrackingPacket
extends AcademyPacket {
    private final Set<UUID> added;
    private final Set<UUID> removed;

    public UpdateOutfitTrackingPacket() {
        this.added = new HashSet<UUID>();
        this.removed = new HashSet<UUID>();
    }

    public UpdateOutfitTrackingPacket(Set<UUID> added, Set<UUID> removed) {
        this.added = added;
        this.removed = removed;
    }

    public Set<UUID> getAdded() {
        return this.added;
    }

    public Set<UUID> getRemoved() {
        return this.removed;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(object -> {
            JsonArray added = new JsonArray();
            JsonArray removed = new JsonArray();
            for (UUID uuid : this.added) {
                Adapters.UUID.writeJson(uuid).ifPresent(arg_0 -> ((JsonArray)added).add(arg_0));
            }
            for (UUID uuid : this.removed) {
                Adapters.UUID.writeJson(uuid).ifPresent(arg_0 -> ((JsonArray)removed).add(arg_0));
            }
            object.add("added", (JsonElement)added);
            object.add("removed", (JsonElement)removed);
            return object;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.added.clear();
        this.removed.clear();
        JsonElement jsonElement = json.get("added");
        if (jsonElement instanceof JsonArray) {
            JsonArray added = (JsonArray)jsonElement;
            added.forEach(uuid -> Adapters.UUID.readJson((JsonElement)uuid).ifPresent(this.added::add));
        }
        if ((jsonElement = json.get("removed")) instanceof JsonArray) {
            JsonArray removed = (JsonArray)jsonElement;
            removed.forEach(uuid -> Adapters.UUID.readJson((JsonElement)uuid).ifPresent(this.removed::add));
        }
    }
}

