/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.api.AcademyPacket;
import abeshutt.staracademy.api.OutfitManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class UpdateOutfitEntryPacket
extends AcademyPacket {
    private final Map<UUID, OutfitManager.Entry> entries;

    public UpdateOutfitEntryPacket() {
        this.entries = new HashMap<UUID, OutfitManager.Entry>();
    }

    public UpdateOutfitEntryPacket(Map<UUID, OutfitManager.Entry> entries) {
        this.entries = entries;
    }

    public Map<UUID, OutfitManager.Entry> getEntries() {
        return this.entries;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(object -> {
            JsonObject entries = new JsonObject();
            this.entries.forEach((uuid, entry) -> entry.writeJson().ifPresent(tag -> entries.add(uuid.toString(), (JsonElement)tag)));
            object.add("entries", (JsonElement)entries);
            return object;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.entries.clear();
        JsonElement jsonElement = json.get("entries");
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            for (String key : object.keySet()) {
                JsonElement jsonElement2 = object.get(key);
                if (!(jsonElement2 instanceof JsonObject)) continue;
                JsonObject tag = (JsonObject)jsonElement2;
                try {
                    OutfitManager.Entry entry = new OutfitManager.Entry();
                    entry.readJson(tag);
                    this.entries.put(UUID.fromString(key), entry);
                }
                catch (Exception e) {
                    StarAcademyMod.LOGGER.error("Failed to read UUID {}.", (Object)key, (Object)e);
                }
            }
        }
    }
}

