/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.api.AcademyClient;
import abeshutt.staracademy.api.UpdateOutfitEntryPacket;
import abeshutt.staracademy.api.UpdateOutfitTrackingPacket;
import abeshutt.staracademy.block.entity.renderer.DynamicOutfit;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.IJsonSerializable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_746;

public class OutfitManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final AcademyClient client;
    private final Map<String, DynamicOutfit> registry;
    private final Map<UUID, Entry> entries;
    private final Set<UUID> tracked;

    public OutfitManager(AcademyClient client) {
        this.client = client;
        this.registry = new HashMap<String, DynamicOutfit>();
        this.entries = new HashMap<UUID, Entry>();
        this.tracked = new HashSet<UUID>();
        Path path = Paths.get("codex", "outfits");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.list(path).forEach(child -> {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        return;
                    }
                    if (!child.toString().endsWith(".json")) {
                        return;
                    }
                    String id = child.getFileName().toString().replace(".json", "");
                    try {
                        JsonElement json = JsonParser.parseString((String)Files.readString(child));
                        Adapters.DYNAMIC_OUTFIT.readJson(json).ifPresent(outfit -> this.registry.put(id, (DynamicOutfit)outfit));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, DynamicOutfit> getRegistry() {
        return this.registry;
    }

    public Map<UUID, Entry> getEntries() {
        return this.entries;
    }

    public Set<UUID> getTracked() {
        return this.tracked;
    }

    public Set<String> getEquipped(UUID uuid) {
        if (this.entries.containsKey(uuid)) {
            return this.entries.get((Object)uuid).equipped;
        }
        return new HashSet<String>();
    }

    public void receive(Map<String, DynamicOutfit> registry) {
        this.registry.clear();
        this.registry.putAll(registry);
        this.registry.forEach((id, outfit) -> Adapters.DYNAMIC_OUTFIT.writeJson((DynamicOutfit)outfit).ifPresent(tag -> {
            String json = GSON.toJson(tag);
            Path path = Paths.get("codex", "outfits", id + ".json");
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    public void tick(AcademyClient client) {
        if (client.getMinecraft().field_1687 == null) {
            if (!this.tracked.isEmpty()) {
                client.send(new UpdateOutfitTrackingPacket(new HashSet<UUID>(), this.tracked));
            }
            return;
        }
        HashSet<UUID> added = new HashSet<UUID>();
        HashSet<UUID> removed = new HashSet<UUID>(this.tracked);
        for (class_742 player : client.getMinecraft().field_1687.method_18456()) {
            if (!this.tracked.contains(player.method_5667())) {
                added.add(player.method_5667());
            }
            removed.remove(player.method_5667());
        }
        if (!added.isEmpty() && !removed.isEmpty()) {
            client.send(new UpdateOutfitTrackingPacket(added, removed));
        }
    }

    public boolean isUnlocked(UUID uuid, String id) {
        Entry entry = this.entries.get(uuid);
        if (entry != null) {
            return entry.unlocked.contains(id);
        }
        return false;
    }

    public boolean isEquipped(UUID uuid, String id) {
        Entry entry = this.entries.get(uuid);
        if (entry != null) {
            return entry.equipped.contains(id);
        }
        return false;
    }

    public void setEquipped(String id, boolean equipped) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Entry entry = this.entries.get(player.method_5667());
        if (entry != null) {
            if (equipped) {
                entry.equipped.add(id);
            } else {
                entry.equipped.remove(id);
            }
            this.client.send(new UpdateOutfitEntryPacket(Map.of(player.method_5667(), entry)));
        }
    }

    public static class Entry
    implements IJsonSerializable<JsonObject> {
        private final Set<String> unlocked;
        private final Set<String> equipped;

        public Entry() {
            this.unlocked = new HashSet<String>();
            this.equipped = new HashSet<String>();
        }

        public Entry(Set<String> unlocked, Set<String> equipped) {
            this.unlocked = unlocked;
            this.equipped = equipped;
        }

        public Set<String> getUnlocked() {
            return this.unlocked;
        }

        public Set<String> getEquipped() {
            return this.equipped;
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(object -> {
                JsonArray unlocked = new JsonArray();
                JsonArray equipped = new JsonArray();
                for (String uuid : this.unlocked) {
                    Adapters.UTF_8.writeJson(uuid).ifPresent(arg_0 -> ((JsonArray)unlocked).add(arg_0));
                }
                for (String uuid : this.equipped) {
                    Adapters.UTF_8.writeJson(uuid).ifPresent(arg_0 -> ((JsonArray)equipped).add(arg_0));
                }
                object.add("unlocked", (JsonElement)unlocked);
                object.add("equipped", (JsonElement)equipped);
                return object;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.unlocked.clear();
            this.equipped.clear();
            JsonElement jsonElement = json.get("unlocked");
            if (jsonElement instanceof JsonArray) {
                JsonArray unlocked = (JsonArray)jsonElement;
                unlocked.forEach(uuid -> Adapters.UTF_8.readJson((JsonElement)uuid).ifPresent(this.unlocked::add));
            }
            if ((jsonElement = json.get("equipped")) instanceof JsonArray) {
                JsonArray equipped = (JsonArray)jsonElement;
                equipped.forEach(uuid -> Adapters.UTF_8.readJson((JsonElement)uuid).ifPresent(this.equipped::add));
            }
        }
    }
}

