/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.api.AcademyClient;
import abeshutt.staracademy.api.CompleteAuthPacket;
import abeshutt.staracademy.api.HelloPacket;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.ForcedUsernameChangeException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import net.minecraft.class_320;

public class AuthManager {
    private Boolean authed = null;

    public Boolean getAuthed() {
        return this.authed;
    }

    public void setAuthed(Boolean authed) {
        this.authed = authed;
    }

    public void start(AcademyClient client) {
        class_320 session = client.getMinecraft().method_1548();
        client.send(new HelloPacket(session.method_44717(), session.method_1676()));
    }

    public void challenge(AcademyClient client, String serverId) {
        class_320 session = client.getMinecraft().method_1548();
        MinecraftSessionService sessionService = client.getMinecraft().method_1495();
        try {
            sessionService.joinServer(session.method_44717(), session.method_1674(), serverId);
            client.send(new CompleteAuthPacket(true, null));
        }
        catch (Exception e) {
            String reason = "Failed to log in: %s.".formatted(e.getMessage());
            if (e instanceof AuthenticationUnavailableException) {
                reason = "The authentication servers are currently not reachable. Please try again.";
            } else if (e instanceof InvalidCredentialsException) {
                reason = "Invalid session (Try restarting your game and the launcher).";
            } else if (e instanceof InsufficientPrivilegesException) {
                reason = "Multiplayer is disabled. Please check your Microsoft account settings.";
            } else if (e instanceof ForcedUsernameChangeException || e instanceof UserBannedException) {
                reason = "You are banned from playing online.";
            }
            StarAcademyMod.LOGGER.error(reason, (Throwable)e);
            client.send(new CompleteAuthPacket(false, reason));
            client.disconnect();
        }
    }

    public void complete(AcademyClient client, boolean success) {
        if (success) {
            this.authed = true;
            return;
        }
        StarAcademyMod.LOGGER.error("Failed the challenge, failed to authenticate.");
    }
}

