/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.api.AcademyPacket;
import abeshutt.staracademy.api.ChallengeAuthPacket;
import abeshutt.staracademy.api.CheckCodexPacket;
import abeshutt.staracademy.api.CompleteAuthPacket;
import abeshutt.staracademy.api.HelloPacket;
import abeshutt.staracademy.api.UpdateCodexPacket;
import abeshutt.staracademy.api.UpdateOutfitEntryPacket;
import abeshutt.staracademy.api.UpdateOutfitRegistryPacket;
import abeshutt.staracademy.api.UpdateOutfitTrackingPacket;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class AcademyPackets {
    private static final Map<String, Supplier<? extends AcademyPacket>> ID_TO_CONSTRUCTOR = new HashMap<String, Supplier<? extends AcademyPacket>>();
    private static final Map<Class<?>, String> CLASS_TO_ID = new HashMap();

    public static <T extends AcademyPacket> void register(String id, Class<T> type, Supplier<T> constructor) {
        ID_TO_CONSTRUCTOR.put(id, constructor);
        CLASS_TO_ID.put(type, id);
    }

    public static void register() {
        AcademyPackets.register("hello", HelloPacket.class, HelloPacket::new);
        AcademyPackets.register("challenge_auth", ChallengeAuthPacket.class, ChallengeAuthPacket::new);
        AcademyPackets.register("complete_auth", CompleteAuthPacket.class, CompleteAuthPacket::new);
        AcademyPackets.register("check_codex", CheckCodexPacket.class, CheckCodexPacket::new);
        AcademyPackets.register("update_codex", UpdateCodexPacket.class, UpdateCodexPacket::new);
        AcademyPackets.register("update_outfit_registry", UpdateOutfitRegistryPacket.class, UpdateOutfitRegistryPacket::new);
        AcademyPackets.register("update_outfit_entry", UpdateOutfitEntryPacket.class, UpdateOutfitEntryPacket::new);
        AcademyPackets.register("update_outfit_tracking", UpdateOutfitTrackingPacket.class, UpdateOutfitTrackingPacket::new);
    }

    public static Optional<JsonObject> encode(AcademyPacket packet) {
        String type = CLASS_TO_ID.get(packet.getClass());
        if (type == null) {
            StarAcademyMod.LOGGER.error("Attempted to encode unregistered packet {}{}.", (Object)packet.getClass().getSimpleName(), (Object)packet.writeJson().orElseGet(JsonObject::new));
            return Optional.empty();
        }
        return packet.writeJson().map(object -> {
            object.addProperty("type", type);
            return object;
        });
    }

    public static Optional<AcademyPacket> decode(JsonObject json) {
        String type;
        String string = type = json.has("type") ? json.get("type").getAsString() : null;
        if (type == null || !ID_TO_CONSTRUCTOR.containsKey(type)) {
            StarAcademyMod.LOGGER.error("Attempted to decode unknown packet {}.", (Object)json);
            return Optional.empty();
        }
        AcademyPacket packet = ID_TO_CONSTRUCTOR.get(type).get();
        try {
            packet.readJson(json);
        }
        catch (Exception e) {
            StarAcademyMod.LOGGER.error("Failed to deserialize packet {}.", (Object)json, (Object)e);
        }
        return Optional.of(packet);
    }
}

