/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.api;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.api.AcademyPacket;
import abeshutt.staracademy.api.AcademyPackets;
import abeshutt.staracademy.api.AuthManager;
import abeshutt.staracademy.api.ChallengeAuthPacket;
import abeshutt.staracademy.api.CodexManager;
import abeshutt.staracademy.api.CompleteAuthPacket;
import abeshutt.staracademy.api.OutfitManager;
import abeshutt.staracademy.api.UpdateCodexPacket;
import abeshutt.staracademy.api.UpdateOutfitEntryPacket;
import abeshutt.staracademy.api.UpdateOutfitRegistryPacket;
import abeshutt.staracademy.api.WebSocketClient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Random;
import net.minecraft.class_310;

public class AcademyClient {
    private final class_310 minecraft;
    private final WebSocketClient socket;
    private int timeout;
    private final AuthManager auth;
    private final CodexManager codex;
    private final OutfitManager outfits;
    private boolean connecting;

    public AcademyClient(class_310 minecraft) {
        this.minecraft = minecraft;
        this.socket = new WebSocketClient("wss://cobblemon.academy/live", message -> {
            try {
                JsonElement json = JsonParser.parseString((String)message);
                if (json instanceof JsonObject) {
                    JsonObject object = (JsonObject)json;
                    AcademyPackets.decode(object).ifPresent(this::receive);
                } else {
                    StarAcademyMod.LOGGER.error("Packet is not an object {}.", message);
                }
            }
            catch (Exception e) {
                StarAcademyMod.LOGGER.error("Failed to parse packet {}.", message, (Object)e);
                this.disconnect();
            }
        });
        this.auth = new AuthManager();
        this.codex = new CodexManager();
        this.outfits = new OutfitManager(this);
        this.connecting = false;
    }

    public class_310 getMinecraft() {
        return this.minecraft;
    }

    public OutfitManager getOutfits() {
        return this.outfits;
    }

    public CodexManager getCodex() {
        return this.codex;
    }

    public void connect() {
        this.connecting = true;
        this.disconnect();
        this.socket.connect();
        this.auth.start(this);
        while (this.socket.isConnected() && !Boolean.TRUE.equals(this.auth.getAuthed())) {
            if (Boolean.FALSE.equals(this.auth.getAuthed())) {
                this.disconnect();
                this.connecting = false;
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.codex.isComplete()) {
            this.codex.check(this);
        }
        this.connecting = false;
    }

    public void disconnect() {
        this.auth.setAuthed(null);
        this.outfits.getTracked().clear();
        this.socket.close();
        this.timeout = 6000 + new Random().nextInt(380);
    }

    public void tick() {
        if (this.connecting) {
            return;
        }
        if (!this.socket.isConnected()) {
            if (this.timeout <= 0) {
                new Thread(this::connect).start();
            } else {
                --this.timeout;
            }
        } else {
            this.timeout = 0;
        }
        if (!this.socket.isConnected() || Boolean.FALSE.equals(this.auth.getAuthed())) {
            return;
        }
        this.outfits.tick(this);
    }

    public void awaitCodex() {
        while (this.socket.isConnected() && !this.codex.isComplete()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void send(AcademyPacket packet) {
        AcademyPackets.encode(packet).ifPresent(object -> this.socket.send(object.toString()));
    }

    public synchronized void receive(AcademyPacket packet) {
        if (this.auth.getAuthed() == null && !(packet instanceof ChallengeAuthPacket) && !(packet instanceof CompleteAuthPacket)) {
            StarAcademyMod.LOGGER.error("Unknown remote authentication protocol.", (Throwable)new Exception());
            this.disconnect();
        }
        if (packet instanceof ChallengeAuthPacket) {
            ChallengeAuthPacket payload = (ChallengeAuthPacket)packet;
            this.auth.challenge(this, payload.getServerId());
        } else if (packet instanceof CompleteAuthPacket) {
            CompleteAuthPacket payload = (CompleteAuthPacket)packet;
            this.auth.complete(this, payload.isSuccess());
        } else if (packet instanceof UpdateCodexPacket) {
            UpdateCodexPacket payload = (UpdateCodexPacket)packet;
            this.codex.receive(this, payload.getAssets(), payload.getData());
        } else if (packet instanceof UpdateOutfitRegistryPacket) {
            UpdateOutfitRegistryPacket payload = (UpdateOutfitRegistryPacket)packet;
            this.outfits.receive(payload.getRegistry());
        } else if (packet instanceof UpdateOutfitEntryPacket) {
            UpdateOutfitEntryPacket payload = (UpdateOutfitEntryPacket)packet;
            this.outfits.getEntries().putAll(payload.getEntries());
        }
    }
}

