/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy;

import abeshutt.staracademy.attribute.Attributes;
import abeshutt.staracademy.compat.enhancedcelestials.EnhancedCelestialsCompat;
import abeshutt.staracademy.event.CommonEvents;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModRegistries;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StarAcademyMod {
    public static final ThreadLocal<Boolean> FORCE_SPAWNING = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Long> QUEST_ID = ThreadLocal.withInitial(() -> 0L);
    public static class_7225.class_7874 REGISTRIES;
    public static final String ID = "academy";
    public static final Logger LOGGER;
    public static final class_5321<class_1937> SAFARI;
    public static List<Runnable> CLIENT_TICKERS;

    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(instance -> {
            REGISTRIES = instance.method_30611();
        });
        if (Platform.isModLoaded((String)"enhancedcelestials")) {
            EnhancedCelestialsCompat.init();
        }
        ModRegistries.register();
        Attributes.init();
        CommonEvents.POKEMON_SENT_PRE.register(event -> {
            if (event.getLevel().method_27983() == SAFARI) {
                event.cancel();
            }
        });
        CommonEvents.BATTLE_STARTED_PRE.register(event -> {
            if (event.getBattle().getPlayers().stream().anyMatch(player -> player.method_37908().method_27983() == SAFARI)) {
                event.cancel();
            }
        });
        CommonEvents.POKEMON_CATCH_RATE.register(event -> {
            if (event.getThrower().method_37908().method_27983() == SAFARI && event.getPokeBallEntity().getPokeBall().item() != CobblemonItems.SAFARI_BALL) {
                event.setCatchRate(0.0f);
            }
        }, Priority.LOWEST);
        CommonEvents.POKEMON_ENTITY_SPAWN.register(event -> {
            double dz;
            if (FORCE_SPAWNING.get().booleanValue()) {
                return;
            }
            class_1937 world = ((PokemonEntity)event.getEntity()).method_5770();
            class_2784 border = world.method_8621();
            double dx = ((PokemonEntity)event.getEntity()).method_19538().method_10216() - border.method_11964();
            double distance = Math.sqrt(dx * dx + (dz = ((PokemonEntity)event.getEntity()).method_19538().method_10215() - border.method_11980()) * dz);
            if (distance <= ModConfigs.POKEMON_SPAWN.getSpawnProtectionDistance()) {
                event.cancel();
                return;
            }
        }, Priority.HIGHEST);
        CommonEvents.POKEMON_ENTITY_SPAWN.register(event -> {
            MinecraftServer server = ((PokemonEntity)event.getEntity()).method_37908().method_8503();
            if (server == null) {
                return;
            }
            Pokemon pokemon = ((PokemonEntity)event.getEntity()).getPokemon();
        }, Priority.LOWEST);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1091 mid(class_2960 id, String variant) {
        return new class_1091(id, variant);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1091 mid(String name, String variant) {
        return StarAcademyMod.mid(StarAcademyMod.id(name), variant);
    }

    public static class_2561 translatableText(String key, Object ... args2) {
        return class_2561.method_43469((String)("academy." + key), (Object[])args2);
    }

    static {
        LOGGER = LogManager.getLogger((String)ID);
        SAFARI = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)StarAcademyMod.id("safari"));
        CLIENT_TICKERS = new ArrayList<Runnable>();
    }
}

