/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.wand.undo;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import pw.smto.constructionwand.Network;
import pw.smto.constructionwand.basics.ConfigServer;
import pw.smto.constructionwand.wand.undo.ISnapshot;

public class UndoHistory {
    private static final HashMap<UUID, PlayerEntityEntry> history = new HashMap();

    private static PlayerEntityEntry getEntryFromPlayerEntity(class_1657 player) {
        return history.computeIfAbsent(player.method_5667(), k -> new PlayerEntityEntry());
    }

    public static void add(class_1657 player, class_1937 world, List<ISnapshot> placeSnapshots) {
        LinkedList<HistoryEntry> list = UndoHistory.getEntryFromPlayerEntity((class_1657)player).entries;
        list.add(new HistoryEntry(placeSnapshots, world));
        while (list.size() > (Integer)ConfigServer.UNDO_HISTORY.get()) {
            list.removeFirst();
        }
    }

    public static void removePlayerEntity(class_1657 player) {
        history.remove(player.method_5667());
    }

    public static void updateClient(class_1657 player, boolean ctrlDown) {
        HistoryEntry entry;
        class_1937 world = player.method_37908();
        if (world.field_9236) {
            return;
        }
        PlayerEntityEntry playerEntry = UndoHistory.getEntryFromPlayerEntity(player);
        playerEntry.undoActive = ctrlDown;
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        Set<Object> positions = historyEntries.isEmpty() ? Collections.emptySet() : ((entry = historyEntries.getLast()) == null || !entry.world.equals(world) ? Collections.emptySet() : entry.getBlockPositions());
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new Network.Payloads.S2CUndoBlocksPayload(positions.stream().toList()));
    }

    public static boolean isUndoActive(class_1657 player) {
        return UndoHistory.getEntryFromPlayerEntity((class_1657)player).undoActive;
    }

    public static boolean undo(class_1657 player, class_1937 world, class_2338 pos) {
        PlayerEntityEntry playerEntry = UndoHistory.getEntryFromPlayerEntity(player);
        if (!playerEntry.undoActive) {
            return false;
        }
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        if (historyEntries.isEmpty()) {
            return false;
        }
        HistoryEntry entry = historyEntries.getLast();
        if (!entry.world.equals(world) || !entry.withinRange(pos)) {
            return false;
        }
        if (entry.undo(player)) {
            historyEntries.remove(entry);
            UndoHistory.updateClient(player, true);
            return true;
        }
        return false;
    }

    private static class PlayerEntityEntry {
        public final LinkedList<HistoryEntry> entries = new LinkedList();
        public boolean undoActive = false;
    }

    private record HistoryEntry(List<ISnapshot> placeSnapshots, class_1937 world) {
        public Set<class_2338> getBlockPositions() {
            return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        }

        public boolean withinRange(class_2338 pos) {
            Set<class_2338> positions = this.getBlockPositions();
            if (positions.contains(pos)) {
                return true;
            }
            for (class_2338 p : positions) {
                if (!pos.method_19771((class_2382)p, 3.0)) continue;
                return true;
            }
            return false;
        }

        public boolean undo(class_1657 player) {
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (snapshot.canRestore(this.world, player)) continue;
                return false;
            }
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (!snapshot.restore(this.world, player) || player.method_7337()) continue;
                for (int i = 0; i < snapshot.getRequiredItems().size(); ++i) {
                    if (i != 0 && !snapshot.shouldGiveBackIncludedItem() || player.method_7270(snapshot.getRequiredItems().get(i))) continue;
                    player.method_7328(snapshot.getRequiredItems().get(i), false);
                }
            }
            player.method_31548().method_5431();
            class_3414 sound = class_3417.field_14890;
            this.world.method_8396(null, player.method_24515(), sound, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
    }
}

