/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.wand.undo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import pw.smto.constructionwand.basics.WandUtil;
import pw.smto.constructionwand.basics.option.WandOptions;
import pw.smto.constructionwand.integrations.ModCompat;
import pw.smto.constructionwand.wand.WandItemUseContext;
import pw.smto.constructionwand.wand.undo.ISnapshot;

public class PlaceSnapshot
implements ISnapshot {
    private class_2680 block;
    private final class_2338 pos;
    private final class_1799 item;
    private final class_1799 includedItem;
    private final boolean giveBackIncludedItem;
    private final class_2680 supportingBlock;
    private final boolean targetMode;

    public PlaceSnapshot(class_2680 block, class_2338 pos, class_1799 item, class_2680 supportingBlock, boolean targetMode, @Nullable class_1799 includedItem, @Nullable boolean giveBackIncludedItem) {
        this.block = block;
        this.pos = pos;
        this.item = item;
        this.supportingBlock = supportingBlock;
        this.targetMode = targetMode;
        this.includedItem = includedItem;
        this.giveBackIncludedItem = giveBackIncludedItem;
    }

    public static PlaceSnapshot get(class_1937 world, class_1657 player, class_3965 rayTraceResult, class_2338 pos, class_1747 item, class_2680 supportingBlock, @Nullable WandOptions options) {
        boolean targetMode = options != null && supportingBlock != null && options.direction.get() == WandOptions.DIRECTION.TARGET;
        class_2680 blockState = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, pos, item, supportingBlock, targetMode);
        if (blockState == null) {
            return null;
        }
        int count = 1;
        if (blockState.method_28501().contains(class_2741.field_12536)) {
            count = (Integer)blockState.method_11654((class_2769)class_2741.field_12536);
        }
        if (blockState.method_28501().contains(class_2741.field_12485) && blockState.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682) {
            count += 2;
        }
        class_1799 includedItem = null;
        boolean giveBackIncludedItem = true;
        if (world.field_9236 || ModCompat.CREATE) {
            // empty if block
        }
        return new PlaceSnapshot(blockState, pos, new class_1799((class_1935)item, count), supportingBlock, targetMode, includedItem, giveBackIncludedItem);
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public class_2680 getBlockState() {
        return this.block;
    }

    @Override
    public boolean shouldGiveBackIncludedItem() {
        return this.giveBackIncludedItem;
    }

    @Override
    public List<class_1799> getRequiredItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        items.add(this.item);
        if (this.includedItem != null) {
            items.add(this.includedItem);
        }
        return items;
    }

    @Override
    public boolean execute(class_1937 world, class_1657 player, class_3965 rayTraceResult) {
        this.block = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, this.pos, (class_1747)this.item.method_7909(), this.supportingBlock, this.targetMode);
        if (this.block == null) {
            return false;
        }
        return WandUtil.placeBlock(world, player, this.block, this.pos, this.item, this.includedItem);
    }

    @Override
    public boolean canRestore(class_1937 world, class_1657 player) {
        return true;
    }

    @Override
    public boolean restore(class_1937 world, class_1657 player) {
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public void forceRestore(class_1937 world) {
        world.method_8650(this.pos, true);
    }

    @Nullable
    private static class_2680 getPlaceBlockstate(class_1937 world, class_1657 player, class_3965 rayTraceResult, class_2338 pos, class_1747 item, @Nullable class_2680 supportingBlock, boolean targetMode) {
        WandItemUseContext ctx = new WandItemUseContext(world, player, rayTraceResult, pos, item);
        if (!ctx.method_7716()) {
            return null;
        }
        class_2680 blockState = item.method_7711().method_9605((class_1750)ctx);
        if (blockState == null || !blockState.method_26184((class_4538)world, pos)) {
            return null;
        }
        if (!WandUtil.isTEAllowed(blockState)) {
            return null;
        }
        if (WandUtil.entitiesCollidingWithBlock(world, blockState, pos)) {
            return null;
        }
        if (targetMode && supportingBlock != null) {
            for (class_2769 property : new class_2769[]{class_2741.field_12481, class_2741.field_12525, class_2741.field_12545, class_2741.field_12532, class_2741.field_12496, class_2741.field_12518, class_2741.field_12503, class_2741.field_12536, class_2741.field_12485}) {
                if (!supportingBlock.method_28501().contains(property) || !blockState.method_28501().contains(property)) continue;
                blockState = (class_2680)blockState.method_11657(property, supportingBlock.method_11654(property));
            }
        }
        return blockState;
    }
}

