/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.wand.supplier;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import pw.smto.constructionwand.api.IWandSupplier;
import pw.smto.constructionwand.basics.ReplacementRegistry;
import pw.smto.constructionwand.basics.WandUtil;
import pw.smto.constructionwand.basics.option.WandOptions;
import pw.smto.constructionwand.basics.pool.IPool;
import pw.smto.constructionwand.basics.pool.OrderedPool;
import pw.smto.constructionwand.containers.ContainerManager;
import pw.smto.constructionwand.wand.undo.PlaceSnapshot;

public class SupplierInventory
implements IWandSupplier {
    protected final class_1657 player;
    protected final WandOptions options;
    protected HashMap<class_1747, Integer> itemCounts;
    protected IPool<class_1747> itemPool;

    public SupplierInventory(class_1657 player, WandOptions options) {
        this.player = player;
        this.options = options;
    }

    @Override
    public void getSupply(@Nullable class_1747 target) {
        this.itemCounts = new LinkedHashMap<class_1747, Integer>();
        class_1799 offhandStack = this.player.method_5998(class_1268.field_5810);
        this.itemPool = new OrderedPool<class_1747>();
        if (!offhandStack.method_7960() && offhandStack.method_7909() instanceof class_1747) {
            this.addBlockItem((class_1747)offhandStack.method_7909());
        } else if (target != null && target != class_1802.field_8162) {
            this.addBlockItem(target);
            if (this.options.match.get() != WandOptions.MATCH.EXACT) {
                for (class_1792 it : ReplacementRegistry.getMatchingSet((class_1792)target)) {
                    if (!(it instanceof class_1747)) continue;
                    this.addBlockItem((class_1747)it);
                }
            }
        }
    }

    protected void addBlockItem(class_1747 item) {
        int count = WandUtil.countItem(this.player, (class_1792)item);
        if (count > 0) {
            this.itemCounts.put(item, count);
            this.itemPool.add(item);
        }
    }

    @Override
    @Nullable
    public PlaceSnapshot getPlaceSnapshot(class_1937 world, class_2338 pos, class_3965 rayTraceResult, @Nullable class_2680 supportingBlock) {
        PlaceSnapshot placeSnapshot;
        class_1747 item;
        int count;
        if (!WandUtil.isPositionPlaceable(world, this.player, pos, this.options.replace.get())) {
            return null;
        }
        this.itemPool.reset();
        do {
            if ((item = this.itemPool.draw()) != null) continue;
            return null;
        } while ((count = this.itemCounts.get(item).intValue()) == 0 || (placeSnapshot = PlaceSnapshot.get(world, this.player, rayTraceResult, pos, item, supportingBlock, this.options)) == null);
        int ncount = count - 1;
        this.itemCounts.put(item, ncount);
        if (ncount == 0) {
            this.itemPool.remove(item);
        }
        return placeSnapshot;
    }

    @Override
    public int takeItemStack(class_1799 stack) {
        int count = stack.method_7947();
        class_1792 item = stack.method_7909();
        if (this.player.method_31548().field_7547 == null) {
            return count;
        }
        if (this.player.method_7337()) {
            return 0;
        }
        List<class_1799> hotbar = WandUtil.getHotbarWithOffhand(this.player);
        List<class_1799> mainInv = WandUtil.getMainInv(this.player);
        count = this.takeItemsInvList(count, item, mainInv, false);
        count = this.takeItemsInvList(count, item, mainInv, true);
        count = this.takeItemsInvList(count, item, hotbar, true);
        count = this.takeItemsInvList(count, item, hotbar, false);
        return count;
    }

    private int takeItemsInvList(int count, class_1792 item, List<class_1799> inv, boolean container) {
        for (class_1799 stack : inv) {
            if (count == 0) break;
            if (container) {
                count = ContainerManager.useItems(this.player, new class_1799((class_1935)item), stack, count);
            }
            if (container || !WandUtil.stackEquals(stack, item)) continue;
            int toTake = Math.min(count, stack.method_7947());
            stack.method_7934(toTake);
            count -= toTake;
            this.player.method_31548().method_5431();
        }
        return count;
    }
}

