/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.wand;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2498;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import pw.smto.constructionwand.ConstructionWand;
import pw.smto.constructionwand.Registry;
import pw.smto.constructionwand.api.IWandAction;
import pw.smto.constructionwand.api.IWandCore;
import pw.smto.constructionwand.api.IWandSupplier;
import pw.smto.constructionwand.basics.ConfigServer;
import pw.smto.constructionwand.basics.option.WandOptions;
import pw.smto.constructionwand.items.wand.ItemWand;
import pw.smto.constructionwand.wand.supplier.SupplierInventory;
import pw.smto.constructionwand.wand.supplier.SupplierRandom;
import pw.smto.constructionwand.wand.undo.ISnapshot;
import pw.smto.constructionwand.wand.undo.UndoHistory;

public class WandJob {
    public final class_1657 player;
    public final class_1937 world;
    public final class_3965 rayTraceResult;
    public final WandOptions options;
    public final class_1799 wand;
    public final ItemWand wandItem;
    private final IWandAction wandAction;
    private final IWandSupplier wandSupplier;
    private List<ISnapshot> placeSnapshots;

    public WandJob(class_1657 player, class_1937 world, class_3965 rayTraceResult, class_1799 wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.method_7909();
        this.options = new WandOptions(wand);
        this.wandSupplier = this.options.random.get() != false ? new SupplierRandom(player, this.options) : new SupplierInventory(player, this.options);
        this.wandAction = ((IWandCore)this.options.cores.get()).getWandAction();
        this.wandSupplier.getSupply(WandJob.getTargetItem(world, rayTraceResult));
    }

    @Nullable
    private static class_1747 getTargetItem(class_1937 world, class_3965 rayTraceResult) {
        class_1792 tgitem = world.method_8320(rayTraceResult.method_17777()).method_26204().method_8389();
        if (!(tgitem instanceof class_1747)) {
            return null;
        }
        return (class_1747)tgitem;
    }

    public void getSnapshots() {
        int limit = this.player.method_7337() && this.wandItem == Registry.Items.INFINITY_WAND ? (Integer)ConfigServer.LIMIT_CREATIVE.get() : Math.min(this.wandItem.remainingDurability(this.wand), this.wandAction.getLimit(this.wand));
        this.placeSnapshots = this.rayTraceResult.method_17783() == class_239.class_240.field_1332 ? this.wandAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit) : this.wandAction.getSnapshotsFromAir(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit);
    }

    public Set<class_2338> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public int blockCount() {
        return this.placeSnapshots.size();
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.method_7960() || this.wandItem.remainingDurability(this.wand) == 0) break;
            ArrayList<class_1799> taken = new ArrayList<class_1799>();
            if (!this.player.method_7337()) {
                boolean success = true;
                for (int i = 0; i < snapshot.getRequiredItems().size(); ++i) {
                    if (this.wandSupplier.takeItemStack(snapshot.getRequiredItems().get(i)) != 0) {
                        ConstructionWand.LOGGER.info("Item could not be taken!");
                        success = false;
                        break;
                    }
                    taken.add(snapshot.getRequiredItems().get(i));
                }
                if (!success) {
                    for (class_1799 item : taken) {
                        if (this.player.method_7270(item)) continue;
                        this.player.method_7328(item, false);
                    }
                    continue;
                }
            }
            if (snapshot.execute(this.world, this.player, this.rayTraceResult)) {
                executed.add(snapshot);
                if (!this.player.method_7337()) {
                    this.wand.method_7970(snapshot.getRequiredItems().get(0).method_7947(), (class_1309)this.player, class_1304.field_6173);
                }
            } else {
                snapshot.forceRestore(this.world);
                for (class_1799 item : taken) {
                    if (this.player.method_7270(item)) continue;
                    this.player.method_7328(item, false);
                }
            }
            this.player.method_7339(Registry.Stats.USE_WAND, 1);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            class_2498 sound = this.placeSnapshots.get(0).getBlockState().method_26231();
            this.world.method_8396(null, this.player.method_24515(), sound.method_10598(), class_3419.field_15245, sound.field_11540, sound.field_11539);
            UndoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }
}

