/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.containers;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import pw.smto.constructionwand.api.IContainerHandler;
import pw.smto.constructionwand.containers.handlers.HandlerBundleComponent;
import pw.smto.constructionwand.containers.handlers.HandlerContainerComponent;
import pw.smto.constructionwand.containers.handlers.HandlerNBTInventory;
import pw.smto.constructionwand.integrations.ModCompat;

public class ContainerManager {
    private static final ArrayList<IContainerHandler> handlers = new ArrayList();
    private static boolean initialized = false;

    public static boolean register(IContainerHandler handler) {
        if (handlers.contains(handler)) {
            return false;
        }
        return handlers.add(handler);
    }

    public static int countItems(class_1657 player, class_1799 itemStack, class_1799 inventoryStack) {
        for (IContainerHandler handler : handlers) {
            if (!handler.matches(player, itemStack, inventoryStack)) continue;
            return handler.countItems(player, itemStack, inventoryStack);
        }
        return 0;
    }

    public static int useItems(class_1657 player, class_1799 itemStack, class_1799 inventoryStack, int count) {
        for (IContainerHandler handler : handlers) {
            if (!handler.matches(player, itemStack, inventoryStack)) continue;
            return handler.useItems(player, itemStack, inventoryStack, count);
        }
        return count;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        ContainerManager.register(new HandlerContainerComponent());
        ContainerManager.register(new HandlerNBTInventory());
        ContainerManager.register(new HandlerBundleComponent());
        ModCompat.registerModContainerHandlers();
        initialized = true;
    }
}

