/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.basics.option;

import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import pw.smto.constructionwand.ConstructionWand;
import pw.smto.constructionwand.api.IWandUpgrade;

public class WandUpgrades<T extends IWandUpgrade> {
    protected final class_2487 tag;
    protected final String key;
    protected final ArrayList<T> upgrades;
    protected final T dval;

    public WandUpgrades(class_2487 tag, String key, T dval) {
        this.tag = tag;
        this.key = key;
        this.dval = dval;
        this.upgrades = new ArrayList();
        if (dval != null) {
            this.upgrades.add(0, dval);
        }
        this.deserialize();
    }

    protected void deserialize() {
        class_2499 listnbt = this.tag.method_10554(this.key, 8);
        boolean require_fix = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            String str = listnbt.method_10608(i);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)str));
            try {
                IWandUpgrade data = (IWandUpgrade)item;
                this.upgrades.add(data);
                continue;
            }
            catch (ClassCastException e) {
                ConstructionWand.LOGGER.warn("Invalid wand upgrade: " + str);
                require_fix = true;
            }
        }
        if (require_fix) {
            this.serialize();
        }
    }

    protected void serialize() {
        class_2499 listnbt = new class_2499();
        for (IWandUpgrade item : this.upgrades) {
            if (item == this.dval) continue;
            listnbt.add((Object)class_2519.method_23256((String)item.getRegistryName().toString()));
        }
        this.tag.method_10566(this.key, (class_2520)listnbt);
    }

    public boolean addUpgrade(T upgrade) {
        if (this.hasUpgrade(upgrade)) {
            return false;
        }
        this.upgrades.add(upgrade);
        this.serialize();
        return true;
    }

    public boolean hasUpgrade(T upgrade) {
        return this.upgrades.contains(upgrade);
    }

    public ArrayList<T> getUpgrades() {
        return this.upgrades;
    }
}

