/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.basics.option;

import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import pw.smto.constructionwand.api.IWandCore;
import pw.smto.constructionwand.api.IWandUpgrade;
import pw.smto.constructionwand.basics.ReplacementRegistry;
import pw.smto.constructionwand.basics.option.IOption;
import pw.smto.constructionwand.basics.option.OptionBoolean;
import pw.smto.constructionwand.basics.option.OptionEnum;
import pw.smto.constructionwand.basics.option.WandUpgradesSelectable;
import pw.smto.constructionwand.items.core.CoreDefault;

public class WandOptions {
    public final class_2487 tag;
    private static final String TAG_ROOT = "wand_options";
    public final WandUpgradesSelectable<IWandCore> cores;
    public final OptionEnum<LOCK> lock;
    public final OptionEnum<DIRECTION> direction;
    public final OptionBoolean replace;
    public final OptionEnum<MATCH> match;
    public final OptionBoolean random;
    public final IOption<?>[] allOptions;

    public WandOptions(class_1799 wandStack) {
        this.tag = ((class_9279)wandStack.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        this.cores = new WandUpgradesSelectable<CoreDefault>(this.tag, "cores", new CoreDefault());
        this.lock = new OptionEnum<LOCK>(this.tag, "lock", LOCK.class, LOCK.NOLOCK);
        this.direction = new OptionEnum<DIRECTION>(this.tag, "direction", DIRECTION.class, DIRECTION.TARGET);
        this.replace = new OptionBoolean(this.tag, "replace", true);
        this.match = new OptionEnum<MATCH>(this.tag, "match", MATCH.class, MATCH.SIMILAR);
        this.random = new OptionBoolean(this.tag, "random", false);
        this.allOptions = new IOption[]{this.cores, this.lock, this.direction, this.replace, this.match, this.random};
    }

    @Nullable
    public IOption<?> get(String key) {
        for (IOption<?> option : this.allOptions) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public boolean testLock(LOCK l) {
        if (this.lock.get() == LOCK.NOLOCK) {
            return true;
        }
        return this.lock.get() == l;
    }

    public boolean matchBlocks(class_2248 b1, class_2248 b2) {
        switch (((MATCH)((Object)this.match.get())).ordinal()) {
            case 0: {
                return b1 == b2;
            }
            case 1: {
                return ReplacementRegistry.matchBlocks(b1, b2);
            }
            case 2: {
                return b1 != class_2246.field_10124 && b2 != class_2246.field_10124;
            }
        }
        return false;
    }

    public boolean hasUpgrade(IWandUpgrade upgrade) {
        if (upgrade instanceof IWandCore) {
            return this.cores.hasUpgrade((IWandCore)upgrade);
        }
        return false;
    }

    public boolean addUpgrade(IWandUpgrade upgrade) {
        if (upgrade instanceof IWandCore) {
            return this.cores.addUpgrade((IWandCore)upgrade);
        }
        return false;
    }

    public void writeToStack(class_1799 item) {
        item.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)this.tag));
    }

    public static enum LOCK {
        HORIZONTAL,
        VERTICAL,
        NORTHSOUTH,
        EASTWEST,
        NOLOCK;

    }

    public static enum DIRECTION {
        TARGET,
        PLAYER;

    }

    public static enum MATCH {
        EXACT,
        SIMILAR,
        ANY;

    }
}

