/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand.basics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import pw.smto.constructionwand.ConstructionWand;
import pw.smto.constructionwand.basics.ConfigServer;
import pw.smto.constructionwand.basics.ReplacementRegistry;
import pw.smto.constructionwand.containers.ContainerManager;
import pw.smto.constructionwand.integrations.ModCompat;
import pw.smto.constructionwand.items.wand.ItemWand;
import pw.smto.constructionwand.wand.WandItemUseContext;

public class WandUtil {
    public static boolean stackEquals(class_1799 stackA, class_1799 stackB) {
        return class_1799.method_7984((class_1799)stackA, (class_1799)stackB);
    }

    public static boolean stackEquals(class_1799 stackA, class_1792 item) {
        class_1799 stackB = new class_1799((class_1935)item);
        return WandUtil.stackEquals(stackA, stackB);
    }

    public static class_1799 holdingWand(class_1657 player) {
        if (player.method_5998(class_1268.field_5808) != class_1799.field_8037 && player.method_5998(class_1268.field_5808).method_7909() instanceof ItemWand) {
            return player.method_5998(class_1268.field_5808);
        }
        if (player.method_5998(class_1268.field_5810) != class_1799.field_8037 && player.method_5998(class_1268.field_5810).method_7909() instanceof ItemWand) {
            return player.method_5998(class_1268.field_5810);
        }
        return null;
    }

    public static class_2338 posFromVec(class_243 vec) {
        return new class_2338((int)Math.round(vec.field_1352), (int)Math.round(vec.field_1351), (int)Math.round(vec.field_1350));
    }

    public static class_243 entityPositionVec(class_1297 entity) {
        return new class_243(entity.method_23317(), entity.method_23318() + (double)(entity.method_17682() / 2.0f), entity.method_23321());
    }

    public static class_243 blockPosVec(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static List<class_1799> getHotbar(class_1657 player) {
        return player.method_31548().field_7547.subList(0, 9);
    }

    public static List<class_1799> getHotbarWithOffhand(class_1657 player) {
        ArrayList<class_1799> inventory = new ArrayList<class_1799>(player.method_31548().field_7547.subList(0, 9));
        inventory.addAll((Collection<class_1799>)player.method_31548().field_7544);
        return inventory;
    }

    public static List<class_1799> getMainInv(class_1657 player) {
        return player.method_31548().field_7547.subList(9, player.method_31548().field_7547.size());
    }

    public static List<class_1799> getFullInv(class_1657 player) {
        ArrayList<class_1799> inventory = new ArrayList<class_1799>((Collection<class_1799>)player.method_31548().field_7544);
        inventory.addAll((Collection<class_1799>)player.method_31548().field_7547);
        return inventory;
    }

    public static int blockDistance(class_2338 p1, class_2338 p2) {
        return Math.max(Math.abs(p1.method_10263() - p2.method_10263()), Math.abs(p1.method_10260() - p2.method_10260()));
    }

    public static boolean isTEAllowed(class_2680 state) {
        if (!state.method_31709()) {
            return true;
        }
        class_2960 name = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (name == null) {
            return false;
        }
        String fullId = name.toString();
        String modId = name.method_12836();
        boolean inList = ((List)ConfigServer.TE_LIST.get()).contains(fullId) || ((List)ConfigServer.TE_LIST.get()).contains(modId);
        boolean isWhitelist = (Boolean)ConfigServer.TE_WHITELIST.get();
        return isWhitelist == inList;
    }

    public static boolean placeBlock(class_1937 world, class_1657 player, class_2680 block, class_2338 pos, @Nullable class_1799 item, @Nullable class_1799 includedItem) {
        class_1799 stack;
        if (!world.method_8501(pos, block)) {
            ConstructionWand.LOGGER.info("Block could not be placed");
            return false;
        }
        if (item == null) {
            stack = new class_1799((class_1935)block.method_26204().method_8389());
        } else {
            stack = item;
            player.method_7342(class_3468.field_15372.method_14956((Object)item.method_7909()), 1);
        }
        block.method_26204().method_9567(world, pos, block, (class_1309)player, stack);
        if (includedItem == null || ModCompat.CREATE) {
            // empty if block
        }
        return true;
    }

    public static boolean removeBlock(class_1937 world, class_1657 player, @Nullable class_2680 block, class_2338 pos) {
        class_2680 currentBlock = world.method_8320(pos);
        if (!world.method_8505(player, pos)) {
            return false;
        }
        if (!player.method_7337()) {
            boolean hasEntity = false;
            class_2586 ent = world.method_8321(pos);
            if (ent != null) {
                hasEntity = true;
                if (ModCompat.CREATE) {
                    // empty if block
                }
            }
            if (currentBlock.method_26214((class_1922)world, pos) <= -1.0f || hasEntity) {
                return false;
            }
            if (block != null && !ReplacementRegistry.matchBlocks(currentBlock.method_26204(), block.method_26204())) {
                return false;
            }
        }
        world.method_8650(pos, false);
        return true;
    }

    public static int countItem(class_1657 player, class_1792 item) {
        if (player.method_31548().field_7547 == null) {
            return 0;
        }
        if (player.method_7337()) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        List<class_1799> inventory = WandUtil.getFullInv(player);
        for (class_1799 stack : inventory) {
            if (stack == null || stack.method_7960()) continue;
            if (WandUtil.stackEquals(stack, item)) {
                total += stack.method_7947();
                continue;
            }
            int amount = ContainerManager.countItems(player, new class_1799((class_1935)item), stack);
            if (amount == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            total += amount;
        }
        return total;
    }

    private static boolean isPositionModifiable(class_1937 world, class_1657 player, class_2338 pos) {
        if (!world.method_24794(pos)) {
            return false;
        }
        if (!world.method_8505(player, pos)) {
            return false;
        }
        return (Integer)ConfigServer.MAX_RANGE.get() <= 0 || WandUtil.blockDistance(player.method_24515(), pos) <= (Integer)ConfigServer.MAX_RANGE.get();
    }

    public static boolean isPositionPlaceable(class_1937 world, class_1657 player, class_2338 pos, boolean replace) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (world.method_22347(pos)) {
            return true;
        }
        return replace && world.method_8320(pos).method_26166((class_1750)new WandItemUseContext(world, player, new class_3965(new class_243(0.0, 0.0, 0.0), class_2350.field_11033, pos, false), pos, (class_1747)class_1802.field_20391));
    }

    public static boolean isBlockRemovable(class_1937 world, class_1657 player, class_2338 pos) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (!player.method_7337()) {
            return !(world.method_8320(pos).method_26214((class_1922)world, pos) <= -1.0f) && world.method_8321(pos) == null;
        }
        return true;
    }

    public static boolean isBlockPermeable(class_1937 world, class_2338 pos) {
        return world.method_22347(pos) || world.method_8320(pos).method_26220((class_1922)world, pos).method_1110();
    }

    public static boolean entitiesCollidingWithBlock(class_1937 world, class_2680 blockState, class_2338 pos) {
        class_265 shape = blockState.method_26220((class_1922)world, pos);
        if (!shape.method_1110()) {
            class_238 blockBB = shape.method_1107().method_996(pos);
            return !world.method_8390(class_1309.class, blockBB, Predicate.not(class_1297::method_7325)).isEmpty();
        }
        return false;
    }

    public static class_2350 fromVector(class_243 vector) {
        return class_2350.method_10142((double)vector.field_1352, (double)vector.field_1351, (double)vector.field_1350);
    }
}

