/*
 * Decompiled with CFR 0.152.
 */
package pw.smto.constructionwand;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import pw.smto.constructionwand.basics.WandUtil;
import pw.smto.constructionwand.basics.option.IOption;
import pw.smto.constructionwand.basics.option.WandOptions;
import pw.smto.constructionwand.items.wand.ItemWand;
import pw.smto.constructionwand.wand.undo.UndoHistory;

public class Network {
    public static void init() {
        PayloadTypeRegistry.playS2C().register(Payloads.S2CUndoBlocksPayload.ID, Payloads.S2CUndoBlocksPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(Payloads.C2SQueryUndoPayload.ID, Payloads.C2SQueryUndoPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(Payloads.C2SWandOptionPayload.ID, Payloads.C2SWandOptionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(Payloads.C2SQueryUndoPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            UndoHistory.updateClient((class_1657)player, payload.undoPressed);
        }));
        ServerPlayNetworking.registerGlobalReceiver(Payloads.C2SWandOptionPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            class_1799 wand = WandUtil.holdingWand((class_1657)player);
            if (wand == null) {
                return;
            }
            WandOptions options = new WandOptions(wand);
            IOption<?> option = options.get(payload.key);
            if (option == null) {
                return;
            }
            option.setValueString(payload.value);
            if (payload.notify1) {
                ItemWand.optionMessage((class_1657)player, option);
            }
            options.writeToStack(wand);
            player.method_31548().method_5431();
        }));
    }

    public static class Payloads {

        public record C2SWandOptionPayload(String key, String value, boolean notify1) implements class_8710
        {
            public static final class_8710.class_9154<C2SWandOptionPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"constructionwand", (String)"wand_option"));
            public static final class_9139<class_9129, C2SWandOptionPayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, C2SWandOptionPayload::key, (class_9139)class_9135.field_48554, C2SWandOptionPayload::value, (class_9139)class_9135.field_48547, C2SWandOptionPayload::notify1, C2SWandOptionPayload::new);

            public class_8710.class_9154<? extends class_8710> method_56479() {
                return ID;
            }

            public static C2SWandOptionPayload of(IOption<?> option, boolean notify) {
                return new C2SWandOptionPayload(option.getKey(), option.getValueString(), notify);
            }
        }

        public record C2SQueryUndoPayload(boolean undoPressed) implements class_8710
        {
            public static final class_8710.class_9154<C2SQueryUndoPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"constructionwand", (String)"query_undo"));
            public static final class_9139<class_9129, C2SQueryUndoPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48547, C2SQueryUndoPayload::undoPressed, C2SQueryUndoPayload::new);

            public class_8710.class_9154<? extends class_8710> method_56479() {
                return ID;
            }
        }

        public record S2CUndoBlocksPayload(List<class_2338> blockPosList) implements class_8710
        {
            public static final class_8710.class_9154<S2CUndoBlocksPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"constructionwand", (String)"undo_blocks"));
            public static final class_9139<ByteBuf, List<class_2338>> PACKET_CODEC = new class_9139<ByteBuf, List<class_2338>>(){

                public List<class_2338> decode(ByteBuf byteBuf) {
                    if (byteBuf.readableBytes() <= 0) {
                        return new ArrayList<class_2338>();
                    }
                    ArrayList<class_2338> out = new ArrayList<class_2338>();
                    while (byteBuf.readableBytes() > 0) {
                        out.add(class_2540.method_56335((ByteBuf)byteBuf));
                    }
                    return out;
                }

                public void encode(ByteBuf byteBuf, List<class_2338> blockPosList) {
                    if (blockPosList.isEmpty()) {
                        return;
                    }
                    for (class_2338 blockPos : blockPosList) {
                        class_2540.method_56336((ByteBuf)byteBuf, (class_2338)blockPos);
                    }
                }
            };
            public static final class_9139<class_9129, S2CUndoBlocksPayload> CODEC = class_9139.method_56434(PACKET_CODEC, S2CUndoBlocksPayload::blockPosList, S2CUndoBlocksPayload::new);

            public class_8710.class_9154<? extends class_8710> method_56479() {
                return ID;
            }
        }
    }
}

