/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.blockflags;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;

public class BlockFlagsScreen
extends PopupButtonScreen<BlockFlagsResponse> {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60654((String)"popup/background");
    private final class_8667 layout = class_8667.method_52741();
    private final List<BlockFlag> validFlags = List.of(BlockFlag.Ignore, BlockFlag.Foliage, BlockFlag.Grass, BlockFlag.Water, BlockFlag.Fluid, BlockFlag.OpenToSky, BlockFlag.NoShadow, BlockFlag.Transparency, BlockFlag.Plant, BlockFlag.Crop, BlockFlag.NoTopo, BlockFlag.Force);
    private final class_2561 labelSubmit = class_2561.method_43471((String)"jm.common.submit");
    private final class_2561 labelReset = class_2561.method_43471((String)"jm.common.reset");
    private final class_2561 labelCancel = class_2561.method_43471((String)"jm.common.cancel");
    private final List<CheckBox> checkFlags = new ArrayList<CheckBox>();
    private final EnumSet<BlockFlag> originalFlags;
    private EnumSet<BlockFlag> currentFlags;

    protected BlockFlagsScreen(EnumSet<BlockFlag> flags) {
        super((class_2561)class_2561.method_43473());
        this.response = new BlockFlagsResponse(flags, true);
        this.originalFlags = flags.clone();
        this.currentFlags = flags.clone();
    }

    public void method_25426() {
        this.layout.method_52735(12).method_52740().method_46467();
        class_8667 columnsLayout = class_8667.method_52742();
        columnsLayout.method_52735(24).method_52740().method_46472();
        class_8667 leftColumnLayout = class_8667.method_52741();
        leftColumnLayout.method_52735(12).method_52740().method_46461();
        class_8667 rightColumnLayout = class_8667.method_52741();
        rightColumnLayout.method_52735(12).method_52740().method_46461();
        int count = 0;
        for (BlockFlag flag : this.validFlags) {
            CheckBox check = new CheckBox(Constants.getTranslatedTextComponent(flag.getKey()).getString(), this.currentFlags.contains((Object)flag), this::checkToggled);
            this.checkFlags.add(check);
            if (count < this.validFlags.size() / 2) {
                leftColumnLayout.method_52736((class_8021)check);
            } else {
                rightColumnLayout.method_52736((class_8021)check);
            }
            ++count;
        }
        columnsLayout.method_52736((class_8021)leftColumnLayout);
        columnsLayout.method_52736((class_8021)rightColumnLayout);
        this.layout.method_52736((class_8021)columnsLayout);
        class_8667 bottomButtons = class_8667.method_52742();
        bottomButtons.method_52735(12);
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelSubmit, b -> this.setResponseAndClose(new BlockFlagsResponse(this.currentFlags, false))).method_46432(this.field_22793.method_27525((class_5348)this.labelSubmit) + 10).method_46431());
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelReset, b -> this.reset()).method_46432(this.field_22793.method_27525((class_5348)this.labelReset) + 10).method_46431());
        bottomButtons.method_52736((class_8021)Button.method_46430((class_2561)this.labelCancel, b -> this.setResponseAndClose(new BlockFlagsResponse(this.originalFlags, true))).method_46432(this.field_22793.method_27525((class_5348)this.labelCancel) + 10).method_46431());
        this.layout.method_52736((class_8021)bottomButtons);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    public void renderPopupScreenBackground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(graphics);
        graphics.method_52706(BACKGROUND_SPRITE, this.layout.method_46426() - 18, this.layout.method_46427() - 18, this.layout.method_25368() + 36, this.layout.method_25364() + 36);
    }

    protected void method_48640() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    private void checkToggled(class_4185 button) {
        CheckBox check = (CheckBox)button;
        int index = this.checkFlags.indexOf(check);
        BlockFlag flag = this.validFlags.get(index);
        if (check.getToggled().booleanValue()) {
            this.currentFlags.add(flag);
        } else {
            this.currentFlags.remove((Object)flag);
        }
    }

    private void reset() {
        this.currentFlags = this.originalFlags.clone();
        for (int i = 0; i < this.validFlags.size(); ++i) {
            this.checkFlags.get(i).setToggled(this.currentFlags.contains((Object)this.validFlags.get(i)));
        }
    }

    public record BlockFlagsResponse(EnumSet<BlockFlag> flags, boolean canceled) {
    }
}

