/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.chunk;

import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.map.MapType;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionData;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2818;

public class NBTChunkMD
extends ChunkMD {
    final class_2487 data;
    final class_2818 chunk;
    final class_1923 chunkPos;
    final MapType mapType;

    public NBTChunkMD(class_2818 chunk, class_1923 chunkPos, class_2487 data, MapType mapType) {
        super(chunk, false);
        this.chunk = chunk;
        this.mapType = mapType;
        this.data = data;
        this.chunkPos = chunkPos;
    }

    @Override
    public boolean hasChunk() {
        return this.data != null;
    }

    @Override
    public class_2818 getChunk() {
        return this.chunk;
    }

    @Override
    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
    }

    @Override
    public class_2680 getChunkBlockState(class_2338 blockPos) {
        class_2680 state = this.getBlockState(blockPos);
        return state;
    }

    @Override
    public int getSavedLightValue(int localX, int y, int localZ) {
        class_2338 pos = this.getBlockPos(localX, y, localZ);
        return this.getGetLightValue(pos);
    }

    @Override
    public BlockMD getBlockMD(class_2338 blockPos) {
        return BlockMD.get(this.getBlockState(blockPos));
    }

    @Override
    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        return !this.mapType.isUnderground();
    }

    @Override
    public int getPrecipitationHeight(class_2338 blockPos) {
        return this.getTopY(blockPos);
    }

    @Override
    public int getHeight(class_2338 blockPos) {
        class_2338 pos = new class_2338(this.toWorldX(blockPos.method_10263()), blockPos.method_10264(), this.toWorldZ(blockPos.method_10260()));
        Integer surfaceY = this.getSurfaceY(pos);
        if (surfaceY == null) {
            surfaceY = this.getTopY(pos);
        }
        return surfaceY;
    }

    @Override
    public BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.get(this.getBlockState(this.getBlockPos(localX, y, localZ)));
    }

    @Override
    public class_1959 getBiome(class_2338 blockPos) {
        class_2487 blockData = this.getBlockNBT(blockPos);
        if (blockData.method_10545("biome_name")) {
            String biomeName = blockData.method_10558("biome_name");
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(class_2338 blockPos) {
        class_2487 blockData = this.getBlockNBT(blockPos);
        if (blockData.method_10545("top_y")) {
            return blockData.method_10550("top_y");
        }
        return blockPos.method_10264();
    }

    public Integer getGetLightValue(class_2338 blockPos) {
        class_2487 blockData = this.getBlockNBT(blockPos);
        if (blockData.method_10545("light_value")) {
            return blockData.method_10550("light_value");
        }
        return 0;
    }

    private Integer getSurfaceY(class_2338 blockPos) {
        class_2487 blockData = this.getBlockNBT(blockPos);
        if (blockData.method_10545("surface_y")) {
            return blockData.method_10550("surface_y");
        }
        return null;
    }

    @Override
    public class_2680 getBlockState(class_2338 blockPos) {
        class_2487 blockData = this.getBlockNBT(blockPos);
        class_2680 blockState = RegionData.getBlockState(blockData, blockPos, this.mapType);
        return blockState;
    }

    private class_2487 getBlockNBT(class_2338 blockPos) {
        return RegionData.getBlockDataForChunk(this.data, blockPos.method_10263(), blockPos.method_10260());
    }

    @Override
    public boolean fromNbt() {
        return true;
    }
}

