/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.screen;

import java.util.ArrayList;
import java.util.Comparator;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2645;
import net.minecraft.class_2815;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerAccess;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.mixin.ClientPlayerEntityAccessor;
import wraith.fwaystones.mixin.ServerPlayerEntityAccessor;
import wraith.fwaystones.packets.ForgetWaystonePacket;
import wraith.fwaystones.packets.TeleportToWaystonePacket;
import wraith.fwaystones.registry.CustomScreenHandlerRegistry;
import wraith.fwaystones.util.SearchType;
import wraith.fwaystones.util.TeleportSources;
import wraith.fwaystones.util.Utils;

public abstract class UniversalWaystoneScreenHandler
extends class_1703 {
    protected final class_1657 player;
    protected ArrayList<String> sortedWaystones = new ArrayList();
    protected ArrayList<String> filteredWaystones = new ArrayList();
    protected String filter = "";
    protected class_3917<? extends UniversalWaystoneScreenHandler> type;

    protected UniversalWaystoneScreenHandler(class_3917<? extends UniversalWaystoneScreenHandler> type, int syncId, class_1657 player) {
        super(type, syncId);
        this.player = player;
        this.type = type;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)this.player.method_31548(), x + y * 9 + 9, 2000000000, 2000000000));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)this.player.method_31548(), x, 2000000000, 2000000000));
        }
    }

    public void updateWaystones(class_1657 player) {
        if (!player.method_37908().field_9236) {
            return;
        }
        this.sortedWaystones = new ArrayList();
        if (((PlayerEntityMixinAccess)player).fabricWaystones$shouldViewDiscoveredWaystones()) {
            this.sortedWaystones.addAll(((PlayerAccess)player).fabricWaystones$getHashesSorted());
        }
        if (((PlayerEntityMixinAccess)player).fabricWaystones$shouldViewGlobalWaystones()) {
            for (String waystone : FabricWaystones.WAYSTONE_STORAGE.getGlobals()) {
                if (this.sortedWaystones.contains(waystone)) continue;
                this.sortedWaystones.add(waystone);
            }
        } else {
            this.sortedWaystones.removeIf(FabricWaystones.WAYSTONE_STORAGE::isGlobal);
        }
        this.sortedWaystones.sort(Comparator.comparing(a -> FabricWaystones.WAYSTONE_STORAGE.getName((String)a)));
        this.filterWaystones();
    }

    public boolean method_7604(class_1657 player, int id) {
        if (!player.method_37908().field_9236) {
            return false;
        }
        int waystoneID = Math.floorDiv(id, 2);
        if (waystoneID >= this.filteredWaystones.size()) {
            return false;
        }
        String waystone = this.filteredWaystones.get(waystoneID);
        if (waystone == null) {
            return false;
        }
        if (id % 2 != 0) {
            this.sortedWaystones.remove(waystone);
            this.filteredWaystones.remove(waystone);
            this.onForget(waystone);
            ((PlayerEntityMixinAccess)player).fabricWaystones$forgetWaystone(waystone);
            this.updateWaystones(player);
            ClientPlayNetworking.send((class_8710)new ForgetWaystonePacket(waystone));
        } else {
            TeleportSources source = UniversalWaystoneScreenHandler.getTeleportSource(player);
            if (Utils.canTeleport(player, waystone, source, false)) {
                ClientPlayNetworking.send((class_8710)new TeleportToWaystonePacket(waystone, source.name()));
            }
            this.closeScreen();
        }
        return true;
    }

    @NotNull
    private static TeleportSources getTeleportSource(class_1657 player) {
        TeleportSources source = player.field_7512.method_17358().equals(CustomScreenHandlerRegistry.WAYSTONE_SCREEN) ? TeleportSources.WAYSTONE : (player.field_7512.method_17358().equals(CustomScreenHandlerRegistry.POCKET_WORMHOLE_SCREEN) ? TeleportSources.POCKET_WORMHOLE : (player.field_7512.method_17358().equals(CustomScreenHandlerRegistry.ABYSS_WATCHER_SCREEN) ? TeleportSources.ABYSS_WATCHER : TeleportSources.LOCAL_VOID));
        return source;
    }

    protected void closeScreen() {
        if (this.player == null) {
            return;
        }
        if (this.player.method_37908().field_9236) {
            this.closeOnClient();
        } else {
            ((ServerPlayerEntityAccessor)this.player).getNetworkHandler().method_14364((class_2596)new class_2645(this.field_7763));
            this.player.field_7512.method_7595(this.player);
            this.player.field_7512 = this.player.field_7498;
        }
    }

    protected void closeOnClient() {
        ((ClientPlayerEntityAccessor)this.player).getNetworkHandler().method_52787((class_2596)new class_2815(this.field_7763));
        this.method_34254(class_1799.field_8037);
        this.player.field_7512 = this.player.field_7498;
        class_310.method_1551().method_1507(null);
    }

    public abstract void onForget(String var1);

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getWaystonesCount() {
        return this.filteredWaystones.size();
    }

    public ArrayList<String> getSearchedWaystones() {
        return this.filteredWaystones;
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
    }

    public void filterWaystones() {
        this.filteredWaystones.clear();
        SearchType searchType = ((PlayerEntityMixinAccess)this.player).fabricWaystones$getSearchType();
        for (String waystone : this.sortedWaystones) {
            String name = FabricWaystones.WAYSTONE_STORAGE.getName(waystone).toLowerCase();
            if (!"".equals(this.filter) && !searchType.match(name, this.filter)) continue;
            this.filteredWaystones.add(waystone);
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public void toggleSearchType() {
        PlayerEntityMixinAccess playerAccess = (PlayerEntityMixinAccess)this.player;
        SearchType searchType = playerAccess.fabricWaystones$getSearchType();
        SearchType[] searchValues = SearchType.values();
        playerAccess.fabricWaystones$setSearchType(searchValues[(searchType.ordinal() + 1) % searchValues.length]);
        this.filterWaystones();
    }

    public class_2561 getSearchTypeTooltip() {
        return class_2561.method_43471((String)("fwaystones.gui." + ((PlayerEntityMixinAccess)this.player).fabricWaystones$getSearchType().name().toLowerCase()));
    }
}

