/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme;

import com.buuz135.findme.FindMeConfig;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.network.PositionRequestMessage;
import com.buuz135.findme.network.PositionResponseMessage;
import com.buuz135.findme.network.PullItemRequestMessage;
import com.buuz135.findme.particle.CustomParticleType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class FindMeMod {
    public static final String MOD_ID = "findme";
    public static FindMeConfig CONFIG = new FindMeConfig();
    public static List<BiPredicate<class_2586, class_1799>> BLOCK_CHECKERS = new ArrayList<BiPredicate<class_2586, class_1799>>();
    public static List<IInventoryPuller> BLOCK_EXTRACTORS = new ArrayList<IInventoryPuller>();
    public static final DeferredRegister<class_2396<?>> PARTICLES = DeferredRegister.create((String)"findme", (class_5321)class_7924.field_41210);
    public static CustomParticleType FIND_ME_PARTICLE_TYPE = new CustomParticleType(false);
    public static RegistrySupplier<class_2396<?>> FINDME = PARTICLES.register("particle", () -> FIND_ME_PARTICLE_TYPE);

    public static void init() {
        PARTICLES.register();
        FindMeMod.registerC2S(PositionRequestMessage.TYPE, PositionRequestMessage.CODEC, PositionRequestMessage::handle);
        FindMeMod.registerS2C(PositionResponseMessage.TYPE, PositionResponseMessage.CODEC, PositionResponseMessage::handle);
        FindMeMod.registerC2S(PullItemRequestMessage.TYPE, PullItemRequestMessage.CODEC, PullItemRequestMessage::handle);
        BLOCK_CHECKERS.add((blockEntity, itemStack) -> {
            if (blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                if (inventory.method_5442()) {
                    return false;
                }
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (inventory.method_5438(i).method_7960() || !PositionRequestMessage.compareItems(itemStack, inventory.method_5438(i))) continue;
                    return true;
                }
            }
            return false;
        });
        File file = new File(String.valueOf(Platform.getConfigFolder()) + File.separator + "findme.json");
        if (!file.exists()) {
            FindMeMod.createConfig(file);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileReader reader = new FileReader(file);
            CONFIG = (FindMeConfig)gson.fromJson((Reader)reader, FindMeConfig.class);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            FindMeMod.createConfig(file);
        }
    }

    private static void createConfig(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter fileWriter = new FileWriter(file);
            gson.toJson((Object)CONFIG, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <T extends class_8710> void registerS2C(class_8710.class_9154<T> packetType, class_9139<? super class_9129, T> codec, NetworkManager.NetworkReceiver<T> receiver) {
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(packetType, codec, List.of());
        } else {
            NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), packetType, codec, Collections.emptyList(), receiver);
        }
    }

    private static <T extends class_8710> void registerC2S(class_8710.class_9154<T> packetType, class_9139<? super class_9129, T> codec, NetworkManager.NetworkReceiver<T> receiver) {
        NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), packetType, codec, Collections.emptyList(), receiver);
    }
}

