/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MermodConfig {
    public static final Server SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;

    public static double getSwimSpeedMultiplier() {
        return (Double)MermodConfig.SERVER.swimSpeedMultiplier.get();
    }

    public static boolean getWaterBreathing() {
        return (Boolean)MermodConfig.SERVER.waterBreathing.get();
    }

    public static boolean getNightVision() {
        return (Boolean)MermodConfig.SERVER.nightVision.get();
    }

    public static boolean getAquaAffinity() {
        return (Boolean)MermodConfig.SERVER.aquaAffinity.get();
    }

    public static boolean getNightVisionFlashingFix() {
        return (Boolean)MermodConfig.CLIENT.nightVisionFlashingFix.get();
    }

    public static boolean getReplaceSwimAnimation() {
        return (Boolean)MermodConfig.CLIENT.replaceSwimAnimation.get();
    }

    public static void setNightVisionFlashingFix(boolean value) {
        MermodConfig.CLIENT.nightVisionFlashingFix.set((Object)value);
    }

    public static void setReplaceSwimAnimation(boolean value) {
        MermodConfig.CLIENT.replaceSwimAnimation.set((Object)value);
    }

    static {
        Pair serverPair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverPair.getLeft();
        SERVER_SPEC = (ModConfigSpec)serverPair.getRight();
        Pair clientPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)clientPair.getRight();
    }

    public static class Server {
        public ModConfigSpec.DoubleValue swimSpeedMultiplier;
        public ModConfigSpec.BooleanValue waterBreathing;
        public ModConfigSpec.BooleanValue nightVision;
        public ModConfigSpec.BooleanValue aquaAffinity;

        Server(ModConfigSpec.Builder builder) {
            builder.push("Server");
            this.swimSpeedMultiplier = builder.comment("Swim speed multiplier").defineInRange("swimSpeedMultiplier", 2.0, 1.0, 10.0);
            this.waterBreathing = builder.comment("Water breathing").define("waterBreathing", true);
            this.nightVision = builder.comment("Night vision").define("nightVision", true);
            this.aquaAffinity = builder.comment("Aqua affinity").define("aquaAffinity", true);
            builder.pop();
        }
    }

    public static class Client {
        public ModConfigSpec.BooleanValue nightVisionFlashingFix;
        public ModConfigSpec.BooleanValue replaceSwimAnimation;

        Client(ModConfigSpec.Builder builder) {
            builder.push("Client");
            this.nightVisionFlashingFix = builder.comment("Night vision flashing fix").define("nightVisionFlashingFix", true);
            this.replaceSwimAnimation = builder.comment("Replace swim animation").define("replaceSwimAnimation", true);
            builder.pop();
        }
    }
}

