/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.compat;

import io.github.thatpreston.mermod.Mermod;
import io.github.thatpreston.mermod.client.render.TailStyle;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.entries.FiguraAPI;
import org.figuramc.figura.entries.annotations.FiguraAPIPlugin;
import org.figuramc.figura.lua.LuaWhitelist;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@FiguraAPIPlugin
@LuaWhitelist
public class MermodFiguraAPI
implements FiguraAPI {
    private static final Object2BooleanMap<UUID> TAIL_VISIBLE = new Object2BooleanOpenHashMap();
    private Avatar avatar;

    public MermodFiguraAPI() {
    }

    public MermodFiguraAPI(Avatar avatar) {
        this.avatar = avatar;
    }

    public FiguraAPI build(Avatar avatar) {
        return new MermodFiguraAPI(avatar);
    }

    public String getName() {
        return "mermod_tail";
    }

    public Collection<Class<?>> getWhitelistedClasses() {
        return List.of(MermodFiguraAPI.class);
    }

    public Collection<Class<?>> getDocsClasses() {
        return List.of();
    }

    @LuaWhitelist
    public void setVisible(boolean value) {
        TAIL_VISIBLE.put((Object)this.avatar.owner, value);
    }

    @LuaWhitelist
    public LuaValue getTailStyle() {
        class_1657 player;
        TailStyle style;
        class_1297 entity = this.avatar.luaRuntime.getUser();
        if (entity instanceof class_1657 && (style = Mermod.getTailStyle(player = (class_1657)entity)) != null) {
            LuaTable table = new LuaTable();
            table.set("texture", (LuaValue)LuaValue.valueOf((String)style.texture().toString()));
            table.set("model", (LuaValue)LuaValue.valueOf((int)style.model()));
            MermodFiguraAPI.setRGB(table, "tailColor", style.tailColor());
            table.set("hasBra", (LuaValue)LuaValue.valueOf((boolean)style.hasBra()));
            MermodFiguraAPI.setRGB(table, "braColor", style.braColor());
            table.set("hasGradient", (LuaValue)LuaValue.valueOf((boolean)style.hasGradient()));
            MermodFiguraAPI.setRGB(table, "gradientColor", style.gradientColor());
            table.set("hasGlint", (LuaValue)LuaValue.valueOf((boolean)style.hasGlint()));
            table.set("permanent", (LuaValue)LuaValue.valueOf((boolean)style.permanent()));
            return table;
        }
        return LuaValue.NIL;
    }

    private static void setRGB(LuaTable table, String name, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        table.set(name + "R", (double)red);
        table.set(name + "G", (double)green);
        table.set(name + "B", (double)blue);
    }

    public static boolean isTailVisible(UUID uuid) {
        return TAIL_VISIBLE.getOrDefault((Object)uuid, true);
    }

    public static void resetVisible(UUID uuid) {
        TAIL_VISIBLE.removeBoolean((Object)uuid);
    }
}

