/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.client.render;

import io.github.thatpreston.mermod.item.modifier.NecklaceModifier;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifiers;
import io.github.thatpreston.mermod.registry.RegistryHandler;
import java.util.HashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9282;
import net.minecraft.class_9331;

public record TailStyle(class_2960 texture, int model, int tailColor, boolean hasBra, int braColor, boolean hasGradient, int gradientColor, boolean hasGlint, boolean permanent) {
    public static final class_2960 DEFAULT_TEXTURE = class_2960.method_60655((String)"mermod", (String)"textures/tail/tail.png");
    private static final HashMap<String, class_2960> TAIL_LOCATION_CACHE = new HashMap();

    public static TailStyle fromNecklace(class_1799 necklace) {
        NecklaceModifiers component = (NecklaceModifiers)necklace.method_57824((class_9331)RegistryHandler.NECKLACE_MODIFIERS.get());
        String textureName = "";
        int model = 0;
        boolean hasBra = false;
        int braColor = -1;
        boolean hasGradient = false;
        int gradientColor = -1;
        boolean hasGlint = false;
        boolean permanent = false;
        if (component != null) {
            NecklaceModifier tail = component.get("tail");
            NecklaceModifier bra = component.get("bra");
            NecklaceModifier gradient = component.get("gradient");
            if (tail != null) {
                textureName = tail.texture();
                model = tail.model();
            }
            if (bra != null) {
                hasBra = true;
                braColor = bra.color();
            }
            if (gradient != null) {
                hasGradient = true;
                gradientColor = gradient.color();
            }
            hasGlint = component.contains("glint");
            permanent = component.contains("permanent");
        }
        int tailColor = class_9282.method_57470((class_1799)necklace, (int)-1);
        class_2960 texture = textureName.isEmpty() ? DEFAULT_TEXTURE : TailStyle.getTailLocation(textureName, tailColor != -1 || braColor != -1 || hasGradient);
        return new TailStyle(texture, model, tailColor, hasBra, braColor, hasGradient, gradientColor, hasGlint, permanent);
    }

    private static class_2960 getTailLocation(String name, boolean colorable) {
        String string = "textures/tail/" + name + (colorable ? "_colorable" : "") + ".png";
        return TAIL_LOCATION_CACHE.computeIfAbsent(string, path -> class_2960.method_60655((String)"mermod", (String)path));
    }
}

