/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.text.DecimalFormat;
import org.popcraft.chunky.Selection;

public final class Formatting {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.##");
    private static final char[] BINARY_PREFIXES = new char[]{'K', 'M', 'G', 'T', 'P'};

    private Formatting() {
    }

    public static String bytes(long bytes) {
        long prefixValue;
        long value;
        long l = value = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (value < 1024L) {
            return String.format("%d B", bytes);
        }
        int i = BINARY_PREFIXES.length - 1;
        for (prefixValue = 1L << BINARY_PREFIXES.length * 10; i > 0 && value < prefixValue; prefixValue >>= 10, --i) {
        }
        return String.format("%.1f %cB", (double)bytes / (double)prefixValue, Character.valueOf(BINARY_PREFIXES[i]));
    }

    public static String radius(Selection selection) {
        if ("rectangle".equals(selection.shape()) || "ellipse".equals(selection.shape())) {
            return String.format("%s, %s", Formatting.number(selection.radiusX()), Formatting.number(selection.radiusZ()));
        }
        return String.format("%s", Formatting.number(selection.radiusX()));
    }

    public static synchronized String number(double number) {
        return NUMBER_FORMAT.format(number);
    }
}

