/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneType;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneBlockVariant {
    private final StoneType stoneType;
    private final BlockVariant blockVariant;
    private final class_2248[] blocks;

    public StoneBlockVariant(StoneType stoneType, BlockVariant blockVariant) {
        this(stoneType, blockVariant, new class_2248[4]);
    }

    protected StoneBlockVariant(StoneType stoneType, BlockVariant blockVariant, class_2248[] blocks) {
        this.stoneType = stoneType;
        this.blockVariant = blockVariant;
        this.blocks = blocks;
    }

    public StoneType stoneType() {
        return this.stoneType;
    }

    public BlockVariant blockVariant() {
        return this.blockVariant;
    }

    public final String name() {
        return this.blockVariant.getName(this.stoneType);
    }

    public String blockName() {
        return this.name();
    }

    public String stairsName() {
        return this.blockVariant.getAdditionalName(this.stoneType, "stairs");
    }

    public String slabName() {
        return this.blockVariant.getAdditionalName(this.stoneType, "slab");
    }

    public String wallName() {
        return this.blockVariant.getAdditionalName(this.stoneType, "wall");
    }

    public void addTranslations(Map<class_2248, String> translations) {
        translations.put(this.block(), StoneBlockVariant.convertLowerUnderscoreToText(this.name()));
        if (this.blockVariant.supportsAdditionalBlocks()) {
            translations.put(this.stairs(), StoneBlockVariant.convertLowerUnderscoreToText(this.stairsName()));
            translations.put(this.slab(), StoneBlockVariant.convertLowerUnderscoreToText(this.slabName()));
            translations.put(this.wall(), StoneBlockVariant.convertLowerUnderscoreToText(this.wallName()));
        }
    }

    private static String convertLowerUnderscoreToText(String lowerUnderscore) {
        String[] strings = lowerUnderscore.split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String string : strings) {
            joiner.add(Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : ""));
        }
        return joiner.toString();
    }

    public Stream<class_2248> allBlocks() {
        return Stream.of(this.block(), this.stairs(), this.slab(), this.wall()).filter(Objects::nonNull);
    }

    @NotNull
    public class_2248 block() {
        return Objects.requireNonNull(this.block(0, this.blockName()), "base block is null");
    }

    @Nullable
    public class_2248 stairs() {
        return this.block(1, this.stairsName());
    }

    @Nullable
    public class_2248 slab() {
        return this.block(2, this.slabName());
    }

    @Nullable
    public class_2248 wall() {
        return this.block(3, this.wallName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private class_2248 block(int index, String key) {
        if (this.blocks[index] == null && (this.isVanillaVariant() || index == 0 || this.blockVariant.supportsAdditionalBlocks())) {
            class_2960 id = this.id(key);
            if (!class_7923.field_41175.method_10250(id)) {
                if (!this.isVanillaVariant()) throw new IllegalArgumentException("Not a valid block: " + String.valueOf(id));
                this.blocks[index] = class_2246.field_10124;
            } else {
                this.blocks[index] = (class_2248)class_7923.field_41175.method_10223(id);
            }
        }
        if (this.blocks[index] == class_2246.field_10124) {
            return null;
        }
        class_2248 class_22482 = this.blocks[index];
        return class_22482;
    }

    public class_2960 id(String key) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)"stoneworks", (String)key);
    }

    public class_2680 baseBlockState() {
        return this.stoneType.getDefaultBlockState(this.blockVariant);
    }

    public class_4970.class_2251 baseBlockProperties() {
        return this.stoneType.getBlockProperties(this.blockVariant);
    }

    public boolean isVanillaVariant() {
        return false;
    }
}

