/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.mixin.battle;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.IgnoredInstruction;
import com.cobblemon.yajatkaul.mega_showdown.instructions.CanDynamaxInstruction;
import com.cobblemon.yajatkaul.mega_showdown.instructions.UltraInstruction;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function6;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShowdownInterpreter.class}, remap=false)
public abstract class ShowdownInterpreterMixin {
    @Final
    @Shadow
    private static Map<String, Object> updateInstructionParser;
    @Final
    @Shadow
    private static Map<String, Object> splitInstructionParser;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void injectBurst(CallbackInfo ci) {
        try {
            updateInstructionParser.put("split", (battle, instructionSet, message, messages) -> {
                BattleMessage privateMessage = (BattleMessage)messages.next();
                BattleMessage publicMessage = (BattleMessage)messages.next();
                BattleActor targetActor = battle.getActor(message.argumentAt(0));
                if (targetActor == null) {
                    return new IgnoredInstruction();
                }
                String raw = publicMessage.getRawMessage();
                String type = raw != null && raw.contains("|") ? raw.split("\\|")[1] : "ignored";
                Function6 splitHandler = (Function6)splitInstructionParser.get(type);
                if (splitHandler != null) {
                    return (InterpreterInstruction)splitHandler.invoke(battle, (Object)targetActor, instructionSet, (Object)publicMessage, (Object)privateMessage, messages);
                }
                return new IgnoredInstruction();
            });
            Function4 ultraBurstFunction = (battle, set, message, messages) -> new UltraInstruction((BattleMessage)message);
            updateInstructionParser.put("-burst", ultraBurstFunction);
            Function4 canDynamaxFunction = (battle, set, message, messages) -> new CanDynamaxInstruction((BattleMessage)message);
            updateInstructionParser.put("-candynamax", canDynamaxFunction);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to inject showdownInterpretations", e);
        }
    }
}

