/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokeball.ThrownPokeballHitEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datapack.handler.EventHandler;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers.HeldItemChangeHandler;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.tera.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.GlowHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.SnowStormHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class CobbleEventsHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Pre event) {
        if (event.getReceiving() == event.getReturning() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        PokemonEntity pokemonEntity = event.getPokemon().getEntity();
        if (pokemonEntity == null || ((Boolean)pokemonEntity.method_5841().method_12789(PokemonEntity.getEVOLUTION_STARTED())).booleanValue()) {
            event.cancel();
            return Unit.INSTANCE;
        }
        HeldItemChangeHandler.genesectChange(event);
        HeldItemChangeHandler.silvallyChange(event);
        HeldItemChangeHandler.arcuesChange(event);
        HeldItemChangeHandler.ultraEvent(event);
        HeldItemChangeHandler.crownedEvent(event);
        HeldItemChangeHandler.ogerponChange(event);
        HeldItemChangeHandler.eternamaxChange(event);
        HeldItemChangeHandler.originChange(event);
        EventHandler.customEvents(event);
        HeldItemChangeHandler.primalEvent(event);
        if (MegaShowdownConfig.battleModeOnly.get().booleanValue()) {
            return Unit.INSTANCE;
        }
        HeldItemChangeHandler.megaEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        class_3222 player = post.getPlayer();
        Pokemon released = post.getPokemon();
        if (released.getSpecies().getName().equals("Meltan")) {
            player.method_7270(new class_1799((class_1935)FormeChangeItems.MELTAN));
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        battle.dispatchWaitingToFront(5.9f, () -> Unit.INSTANCE);
        if (pokemon.getOwnerPlayer() == null) {
            MegaLogic.NPCEvolve(pokemon.getEntity(), megaEvolutionEvent.getPokemon(), battle);
        } else {
            MegaLogic.Evolve(pokemon.getEntity(), (class_1657)pokemon.getOwnerPlayer(), megaEvolutionEvent.getPokemon(), battle);
        }
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z/z_moves");
        if (pk.getSpecies().getName().equals("Pikachu") && pk.getAspects().contains("partner-cap")) {
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "bond/ash_pikachu");
        }
        if (pokemon != null) {
            GlowHandler.applyZGlow(pokemon);
        }
        SnowStormHandler.Companion.snowStormPartileSpawner(pk.getEntity(), class_2960.method_12829((String)"cobblemon:z_moves"), List.of("target"));
        zMoveUsedEvent.getBattle().dispatchWaitingToFront(4.0f, () -> Unit.INSTANCE);
        class_2338 entityPos = pokemon.method_24515();
        pokemon.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ZMOVE, class_3419.field_15248, 0.2f, 0.7f);
        pk.getEntity().after(2.5f, () -> {
            SnowStormHandler.Companion.playAnimation((class_1297)pk.getEntity(), Set.of("cry"), List.of());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "tera/terastallized");
        class_243 entityPos = pokemon.method_19538();
        pokemon.method_37908().method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, ModSounds.TERASTALLIZATION, class_3419.field_15248, 0.2f, 1.0f);
        if (pk.getSpecies().getName().equals("Terapagos")) {
            new StringSpeciesFeature("tera_form", "stellar").apply(pk);
            EventUtils.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon());
        } else if (pk.getSpecies().getName().equals("Ogerpon")) {
            new FlagSpeciesFeature("embody-aspect", true).apply(pk);
            EventUtils.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon());
        }
        pk.getPersistentData().method_10556("is_tera", true);
        GlowHandler.applyTeraGlow(pokemon);
        class_3222 player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        boolean hasTerapagos = false;
        if (player != null) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemonParty : playerPartyStore) {
                if (!pokemonParty.getSpecies().getName().equals("Terapagos")) continue;
                hasTerapagos = true;
                break;
            }
        }
        if (!hasTerapagos) {
            TrinketsApi.getTrinketComponent((class_1309)player).flatMap(component -> component.getAllEquipped().stream().map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof TeraItem).findFirst()).ifPresent(teraOrb -> teraOrb.method_7974(teraOrb.method_7919() + 10));
        }
        PokemonBattle battle = terastallizationEvent.getBattle();
        battle.dispatchWaitingToFront(3.0f, () -> {
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon, Set.of("cry"), List.of());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        boolean stellarSuccess;
        if (!MegaShowdownConfig.teralization.get().booleanValue() || !(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        class_1792 correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)correspondingTeraShard));
        Random random = new Random();
        boolean otherSuccess = random.nextDouble() < MegaShowdownConfig.teraShardDropRate.get() / 100.0;
        boolean bl = stellarSuccess = random.nextDouble() < MegaShowdownConfig.stellarShardDropRate.get() / 100.0;
        if (otherSuccess) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (stellarSuccess) {
            teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)TeraMoves.STELLAR_TERA_SHARD));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        class_3222 player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        if (player == null || pokemonHealedEvent.getSource() != HealingSource.Force.INSTANCE) {
            return Unit.INSTANCE;
        }
        class_1799 teraOrb = TrinketsApi.getTrinketComponent((class_1309)player).flatMap(component -> component.getAllEquipped().stream().map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof TeraItem).findFirst()).orElse(null);
        if (teraOrb != null) {
            teraOrb.method_7974(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        if (formeChangeEvent.getFormeName().equals("x") || formeChangeEvent.getFormeName().equals("y") || formeChangeEvent.getFormeName().equals("mega") || formeChangeEvent.getFormeName().equals("tera")) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        PokemonBattle battle = formeChangeEvent.getBattle();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        class_2338 entityPos = pokemonEntity.method_24515();
        switch (pokemon.getSpecies().getName()) {
            case "Aegislash": {
                if (formeChangeEvent.getFormeName().equals("blade")) {
                    new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("aegislash")) break;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                break;
            }
            case "Arceus": {
                battle.dispatchWaitingToFront(3.0f, () -> {
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ARCEUS_MULTITYPE, class_3419.field_15248, 0.2f, 1.3f);
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemon.getEntity(), class_2960.method_12829((String)("cobblemon:arceus_" + formeChangeEvent.getFormeName())), List.of("target"));
                    pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                    return Unit.INSTANCE;
                });
                pokemon.getEntity().after(4.0f, () -> {
                    new StringSpeciesFeature("multitype", formeChangeEvent.getFormeName()).apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                    pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Minior": {
                if (formeChangeEvent.getFormeName().equals("meteor")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("meteor_shield", "meteor").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("meteor_shield", "core").apply(pokemon);
                break;
            }
            case "Castform": {
                switch (formeChangeEvent.getFormeName()) {
                    case "sunny": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "sunny").apply(pokemon);
                        break;
                    }
                    case "rainy": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "rainy").apply(pokemon);
                        break;
                    }
                    case "snowy": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "snowy").apply(pokemon);
                    }
                }
                break;
            }
            case "Wishiwashi": {
                if (formeChangeEvent.getFormeName().equals("school")) {
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, class_2960.method_12829((String)"cobblemon:wishiwashi_effect"), List.of("target"));
                        pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 1.3f);
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(5.0f, () -> {
                        new StringSpeciesFeature("schooling_form", "school").apply(pokemon);
                        SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                        EventUtils.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon());
                        return Unit.INSTANCE;
                    });
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("wishiwashi")) break;
                new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                break;
            }
            case "Mimikyu": {
                if (!formeChangeEvent.getFormeName().equals("busted")) break;
                new StringSpeciesFeature("disguise_form", "busted").apply(pokemon);
                break;
            }
            case "Greninja": {
                if (formeChangeEvent.getFormeName().equals("ash")) {
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 1.3f);
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, class_2960.method_12829((String)"cobblemon:battlebond_effect"), List.of("target"));
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(4.0f, () -> {
                        new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
                        SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                        EventUtils.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon());
                        return Unit.INSTANCE;
                    });
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_greninja");
                    return Unit.INSTANCE;
                }
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_battle_bond");
                break;
            }
            case "Cherrim": {
                if (formeChangeEvent.getFormeName().equals("sunshine")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("blossom_form", "sunshine").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
                break;
            }
            case "Palafin": {
                if (!formeChangeEvent.getFormeName().equals("hero")) break;
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("dolphin_form", "hero").apply(pokemon);
                break;
            }
            case "Morpeko": {
                if (formeChangeEvent.getFormeName().equals("hangry")) {
                    EventUtils.playFormeChangeAngryAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("hunger_mode", "hangry").apply(pokemon);
                    break;
                }
                new StringSpeciesFeature("hunger_mode", "full_belly").apply(pokemon);
                break;
            }
            case "Eiscue": {
                if (formeChangeEvent.getFormeName().equals("noice")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("penguin_head", "noice_face").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
                break;
            }
            case "Cramorant": {
                switch (formeChangeEvent.getFormeName()) {
                    case "gulping": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gulping").apply(pokemon);
                        break;
                    }
                    case "cramorant": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "none").apply(pokemon);
                        break;
                    }
                    case "gorging": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gorging").apply(pokemon);
                    }
                }
                break;
            }
            case "Darmanitan": {
                if (formeChangeEvent.getFormeName().equals("zen")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("blazing_mode", "zen").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
                break;
            }
            case "Xerneas": {
                if (!formeChangeEvent.getFormeName().equals("active")) break;
                new StringSpeciesFeature("life_mode", "active").apply(pokemon);
                break;
            }
            case "Terapagos": {
                if (!formeChangeEvent.getFormeName().equals("terastal")) break;
                battle.dispatchWaitingToFront(4.5f, () -> {
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, class_2960.method_12829((String)"cobblemon:terapagos_effect"), List.of("target"));
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 2.1f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(3.9f, () -> {
                    new StringSpeciesFeature("tera_form", "terastal").apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                    EventUtils.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon());
                    return Unit.INSTANCE;
                });
                return Unit.INSTANCE;
            }
            case "Meloetta": {
                if (formeChangeEvent.getFormeName().equals("pirouette")) {
                    new StringSpeciesFeature("song_forme", "pirouette").apply(pokemon);
                    EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
                    break;
                }
                new StringSpeciesFeature("song_forme", "aria").apply(pokemon);
                break;
            }
            case "Zygarde": {
                if (!formeChangeEvent.getFormeName().equals("complete")) break;
                pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.POWER_CONSTRUCT, class_3419.field_15248, 0.2f, 0.8f);
                battle.dispatchWaitingToFront(4.5f, () -> {
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, class_2960.method_12829((String)"cobblemon:power_construct_event"), List.of("root"));
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    if (pokemon.getAspects().contains("10-percent")) {
                        pokemon.getPersistentData().method_10582("zygarde_form", "10");
                    } else {
                        pokemon.getPersistentData().method_10582("zygarde_form", "50");
                    }
                    new StringSpeciesFeature("percent_cells", "complete").apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((class_1297)pokemonEntity, Set.of("cry"), List.of());
                    EventUtils.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon());
                    return Unit.INSTANCE;
                });
                return Unit.INSTANCE;
            }
            case "Shaymin": {
                if (!formeChangeEvent.getFormeName().equals("shaymin")) break;
                new StringSpeciesFeature("gracidea_forme", "land").apply(pokemon);
                EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
            }
        }
        EventHandler.battleModeFormChange(formeChangeEvent);
        EventUtils.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon());
        return Unit.INSTANCE;
    }

    public static Unit fixTeraTyping(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            pokemon.setTeraType(TeraTypes.getSTELLAR());
        }
        return Unit.INSTANCE;
    }

    public static Unit pokemonSent(PokemonSentPostEvent pokemonSentPostEvent) {
        PokemonEntity pokemon = pokemonSentPostEvent.getPokemonEntity();
        Pokemon pk = pokemonSentPostEvent.getPokemon();
        if (pk.getPersistentData().method_10577("is_tera")) {
            GlowHandler.applyTeraGlow(pokemon);
        }
        return Unit.INSTANCE;
    }

    public static Unit pokeballHit(ThrownPokeballHitEvent thrownPokeballHitEvent) {
        if (thrownPokeballHitEvent.getPokemon().getAspects().contains("core-percent")) {
            thrownPokeballHitEvent.cancel();
        }
        return Unit.INSTANCE;
    }
}

