/*
 * Decompiled with CFR 0.152.
 */
package dev.elifian.dimworldborder;

import com.mojang.brigadier.CommandDispatcher;
import dev.elifian.dimworldborder.DimensionalWBCommand;
import dev.elifian.dimworldborder.DimensionalWBSavedData;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2596;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5889;
import net.minecraft.class_5895;
import net.minecraft.class_5896;
import net.minecraft.class_5897;
import net.minecraft.class_5898;
import net.minecraft.class_5899;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionalWorldBorder
implements ModInitializer {
    public static final String COPYRIGHT = "\u00a9 2025 Elifian. All rights reserved. Contact: main@elifian.ru";
    public static final String MOD_ID = "dimworldborder";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dimworldborder");

    public void onInitialize() {
        this.onRegisterCommands();
        this.onPlayerLoggedIn();
        this.onPlayerChangedDimension();
        this.onServerStarting();
        this.onWorldSave();
    }

    private void onRegisterCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> DimensionalWBCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private void onPlayerLoggedIn() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            class_3218 level = (class_3218)player.method_37908();
            DimensionalWBSavedData data = DimensionalWBSavedData.get(level);
            class_2784 worldBorder = level.method_8621();
            data.applyTo(worldBorder);
            player.field_13987.method_14364((class_2596)new class_5889(worldBorder));
            server.execute(() -> player.field_13987.method_14364((class_2596)new class_5897(worldBorder)));
        });
    }

    private void onPlayerChangedDimension() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            DimensionalWBSavedData data = DimensionalWBSavedData.get(destination);
            class_2784 worldBorder = destination.method_8621();
            data.applyTo(worldBorder);
            player.field_13987.method_14364((class_2596)new class_5889(worldBorder));
            destination.method_8503().execute(() -> player.field_13987.method_14364((class_2596)new class_5897(worldBorder)));
        });
    }

    private void onServerStarting() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_2784 overworldBorder = server.method_30002().method_8621();
            overworldBorder.field_12730.clear();
            for (class_3218 level : server.method_3738()) {
                this.addWorldborderListener(level);
                DimensionalWBSavedData data = DimensionalWBSavedData.get(level);
                class_2784 worldBorder = level.method_8621();
                data.applyTo(level.method_8621());
            }
            DimensionalWBCommand.loadLocalization();
        });
    }

    private void onWorldSave() {
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            DimensionalWBSavedData data = DimensionalWBSavedData.get(world);
            class_2784 worldBorder = world.method_8621();
            data.setWorldborderSettings(worldBorder.method_27355());
            world.method_17983().method_125();
        });
    }

    private static void broadcastToAllLevelPlayers(class_3218 level, class_2596<?> packet) {
        for (class_3222 player : level.method_18456()) {
            player.field_13987.method_14364(packet);
        }
    }

    private void addWorldborderListener(final class_3218 level) {
        level.method_8621().method_11983(new class_2780(){

            public void method_11934(@NotNull class_2784 border, double size) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5897(border));
            }

            public void method_11931(@NotNull class_2784 border, double oldSize, double newSize, long lerpTime) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5896(border));
            }

            public void method_11930(@NotNull class_2784 border, double centerX, double centerZ) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5895(border));
            }

            public void method_11932(@NotNull class_2784 border, int time) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5898(border));
            }

            public void method_11933(@NotNull class_2784 border, int blocks) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5899(border));
            }

            public void method_11929(@NotNull class_2784 border, double perBlockDamage) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5889(border));
            }

            public void method_11935(@NotNull class_2784 border, double damageSafeZone) {
                DimensionalWorldBorder.broadcastToAllLevelPlayers(level, new class_5889(border));
            }
        });
    }
}

